#include "MapleMini.h"
#include "mbed.h"
#include "USBSerial.h"
#include "DHT.h"

DigitalOut  myled(LED1);
DigitalOut  usb_disc(PB_9);
DHT dht(PA_0,DHT22);

int main() {
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)
       
    //Serial    pc(PA_2, PA_3);
    //USBSerial usbSerial;  // connection must be blocked when USB is not plugged in
    USBSerial usbSerial(0x1f00, 0x2012, 0x0001,  false);    // connection is not blocked when USB is not plugged in
    usb_disc = 0;
    
    while(1) {
        myled = !myled;
        int data=dht.readData();

        // Print on Virtual USB Serial port
        //usb_serial.
        usbSerial.printf("%f,%f,%d\r\n", dht.ReadTemperature(),dht.ReadHumidity(),data);
        wait_ms(1000);
    }
}

