#include <stdio.h>
#include "mbed.h"
#include "BMP180.h"

#include "ble/BLE.h"
#include "Servo.h"
#include "GattCallbackParamTypes.h"

#define BLE_UUID_TXRX_SERVICE            0x0000 /**< The UUID of the Nordic UART Service. */
#define BLE_UUID_TX_CHARACTERISTIC       0x0002 /**< The UUID of the TX Characteristic. */
#define BLE_UUIDS_RX_CHARACTERISTIC      0x0003 /**< The UUID of the RX Characteristic. */

#define TXRX_BUF_LEN                     20

#define DIGITAL_OUT_PIN                  P0_17  //D7
#define DIGITAL_IN_PIN                   P0_5   //A4
#define PWM_PIN                          P0_16  //D6
#define SERVO_PIN                        P0_14  //D10
#define ANALOG_IN_PIN                    P0_6   //A5

//Start Add by Ax 2016-4-23
#include "BMP180.h"
I2C i2c(P0_17, P0_18); 
BMP180 bmp180(&i2c);

//#define DIGITAL_OUT_BlueLed_PIN                 P0_20   //Blue LED P0_19
//#define DIGITAL_OUT_RedLed_PIN                   P0_19 //Red LED P0_20
#define DIGITAL_IN_IsNoPeopleInfront_PIN                  P0_23  //Tx Pin to check if people infront

//#define DIGITAL_IN_IsNoPeopleInfront_PIN                  P0_23  //Tx Pin to check if people infront
//#define DIGITAL_IN_IsNoPeopleInfront_PIN                  P0_23  //Tx Pin to check if people infront
//#define DIGITAL_IN_IsNoPeopleInfront_PIN                  P0_23  //Tx Pin to check if people infront

float arrHistoryEnvironment[2] = {0,0};//total working hours,total rest hours
float arrCurrentEnvironment[3] = {0,0,0};//current working hours,current rest hours,current temperature
float stdWorkHours=60;//60 seconds for testing
float stdRestHours=15;//15 seconds for testing
float stdTemperature=18;//18 degree for testing
int checkCounter=2;

DigitalIn IsNoPeopleInfront(DIGITAL_IN_IsNoPeopleInfront_PIN);
//DigitalOut Blue_Led_SET(DIGITAL_OUT_BlueLed_PIN);
//DigitalOut Red_Led_SET(DIGITAL_OUT_RedLed_PIN);

//End Add by Ax 2016-4-23

BLE             ble;

DigitalOut      LED_SET(DIGITAL_OUT_PIN);
DigitalIn       BUTTON(DIGITAL_IN_PIN);
PwmOut          PWM(PWM_PIN);
AnalogIn        ANALOG(ANALOG_IN_PIN);
Servo           MYSERVO(SERVO_PIN);

Serial pc(USBTX, USBRX);

static uint8_t analog_enabled = 0;
static uint8_t old_state = 0;

// The Nordic UART Service
static const uint8_t uart_base_uuid[] = {0x71, 0x3D, 0, 0, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_tx_uuid[]   = {0x71, 0x3D, 0, 3, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_rx_uuid[]   = {0x71, 0x3D, 0, 2, 0x50, 0x3E, 0x4C, 0x75, 0xBA, 0x94, 0x31, 0x48, 0xF1, 0x8D, 0x94, 0x1E};
static const uint8_t uart_base_uuid_rev[] = {0x1E, 0x94, 0x8D, 0xF1, 0x48, 0x31, 0x94, 0xBA, 0x75, 0x4C, 0x3E, 0x50, 0, 0, 0x3D, 0x71};

uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

//static uint8_t rx_buf[TXRX_BUF_LEN];
//static uint8_t rx_len=0;


GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
                                      
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
                                      
GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic};

GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));



void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    pc.printf("Disconnected \r\n");
    pc.printf("Restart advertising \r\n");
    ble.startAdvertising();
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{   
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead, index;
    
    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) 
    {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);       
        
        for(index=0; index<bytesRead; index++)
            pc.putc(buf[index]);
            
        if(buf[0] == 0x01)
        {
            if(buf[1] == 0x01)
                LED_SET = 1;
            else
                LED_SET = 0;    
        }
        else if(buf[0] == 0xA0)
        {
            if(buf[1] == 0x01)
                analog_enabled = 1;
            else
                analog_enabled = 0;
        }
        else if(buf[0] == 0x02)
        {
            float value = (float)buf[1]/255;
            PWM = value;
        }
        else if(buf[0] == 0x03)
        {
            MYSERVO.write(buf[1]);
        }
        else if(buf[0] == 0x04)
        {
            analog_enabled = 0;
            PWM = 0;
            MYSERVO.write(0);
            LED_SET = 0;
            old_state = 0;    
        }

    }
}
/*
void uartCB(void)
{   
    while(pc.readable())    
    {
        rx_buf[rx_len++] = pc.getc();    
        if(rx_len>=20 || rx_buf[rx_len-1]=='\0' || rx_buf[rx_len-1]=='\n')
        {
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
            pc.printf("RecHandler \r\n");
            pc.printf("Length: ");
            pc.putc(rx_len);
            pc.printf("\r\n");
            rx_len = 0;
            break;
        }
    }
}
*/
void m_status_check_handle(void)
{   
    uint8_t buf[6];
    //float buf[6];
    if (analog_enabled)  // if analog reading enabled
    {
        // Read and send out
        //float s = ANALOG;
        //uint16_t value = s*1024;
        //buf[0] = (0x0B);
        //buf[1] = (value >> 8);
        //buf[2] = (value);
        //ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
              
        //float s = 4;
        //uint16_t value = s*1024;
        //buf[0] = (0x0B);
        //buf[1] = 4.5;
        //buf[2] = 18;
        
        buf[0] = (0x0B);//Result ID
        
        buf[1] = arrHistoryEnvironment[0];//Total Work Hours
        //uint16_t value = arrHistoryEnvironment[0]*1024;
        //buf[1] = (value>>8);//Total Work Hours        
        
        buf[2] = arrHistoryEnvironment[1];//Total Rest Hours
        //value=arrHistoryEnvironment[1]*1024;
        //buf[2] = (value>>8);//Total Rest Hours
        
        buf[3] = arrCurrentEnvironment[0];//Current Work Hours
        //value=arrCurrentEnvironment[0]*1024;
        //buf[3] = (value>>8);//Current Work Hours
        
        buf[4] = arrCurrentEnvironment[1];//Current Rest Hours
        //value=arrCurrentEnvironment[1]*1024;
        //buf[4] = (value>>8);//Current Rest Hours
        
        buf[5] = arrCurrentEnvironment[2];//Current Temperature
        //value=arrCurrentEnvironment[2]*1024;
        //buf[5] = (value>>8);//Current Temperature
        ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 6); 
    }
    
    // If digital in changes, report the state
    if (BUTTON != old_state)
    {
        old_state = BUTTON;
        
        if (BUTTON == 1)
        {
            buf[0] = (0x0A);
            buf[1] = (0x01);
            buf[2] = (0x00);    
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
        }
        else
        {
            buf[0] = (0x0A);
            buf[1] = (0x00);
            buf[2] = (0x00);
           ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
        }
    }
}

//Start Add by Ax 2016-4-23
void GetTemperature() 
{
    while(1) {
        if (bmp180.init() != 0) {
            printf("Error communicating with BMP180\n");
        } else {
            printf("Initialized BMP180\n");
            break;
        }
        wait(1);
    }

    bmp180.startTemperature();
    wait_ms(5);     // Wait for conversion to complete
    float temp;
    while(1)
    {
        if(bmp180.getTemperature(&temp) != 0) {
            printf("Error getting temperature\n");
            continue;
        }
        else
            break;
    }
    arrCurrentEnvironment[2]=temp;
    //bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
    //wait_ms(10);    // Wait for conversion to complete
    //int pressure;
    //if(bmp180.getPressure(&pressure) != 0) {
    //    printf("Error getting pressure\n");
    //    continue;
    //}

    //printf("Pressure = %d Pa Temperature = %f C\n", pressure, temp);
    //wait(1);
}

void CheckEnvironment()
{
    //Blue_Led_SET=1;//Enable bule LED means start to check
    //Red_Led_SET=0;//Disable RED LED means start to check
    for(int i=0;i<checkCounter;i++)
    {
        if(!IsNoPeopleInfront)
        {
            //Red_Led_SET=0;
            //LED_R = 1;            
            //LED_R = 0;
            //wait(1);
            //if check many times there's no people
            if(i==checkCounter-1)
            {
                //if no people there, Add rest hours e.g. 2
                arrCurrentEnvironment[1]=arrCurrentEnvironment[1]+1;
                arrHistoryEnvironment[1]=arrHistoryEnvironment[1]+1;
                
                //if rest enough time, rest working hour and rest hours
                if(arrCurrentEnvironment[1]>stdRestHours)
                {
                    arrCurrentEnvironment[0]=0;
                    arrCurrentEnvironment[1]=0;
                }
            }
        }
        else
        {
            //if people is siting there, Add working hours e.g. 2
            arrCurrentEnvironment[0]=arrCurrentEnvironment[0]+1;
            arrHistoryEnvironment[0]=arrHistoryEnvironment[0]+1;
            arrCurrentEnvironment[1]=0;//Rest hours set to 0
            //if working enough time, warn user
            if(arrCurrentEnvironment[0]>stdWorkHours)
            {
                //Red_Led_SET=1;
                //Blue_Led_SET=0;
            }
            /*
            arrCurrentEnvironment;
            float arrHistoryEnvironment[2] = {0,0};//total working hours,total rest hours
            float arrCurrentEnvironment[3] = {0,0,0};//current working hours,current rest hours,current temperature
            float stdWorkHours=60;//60 seconds for testing
            float stdRestHours=15;//15 seconds for testing
            float stdTemperature=18;//18 degree for testing
            */
        }
        wait(1);
    }
    
    GetTemperature();
}
//End Add by Ax 2016-4-23

int main(void)
{   
    Ticker ticker;
    ticker.attach_us(m_status_check_handle, 200000);
    
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(WrittenHandler);  
    
    pc.baud(9600);
    pc.printf("SimpleChat Init \r\n");

    //pc.attach( uartCB , pc.RxIrq);
    
    // setup advertising 
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)"Biscuit", sizeof("Biscuit") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    // 100ms; in multiples of 0.625ms. 
    ble.setAdvertisingInterval(160);

    ble.addService(uartService);
    
    ble.startAdvertising(); 
    
    pc.printf("Advertising Start \r\n");
    
    while(1)
    {
        ble.waitForEvent(); 
        //Check Temperature & People sitting time
        CheckEnvironment();
        //wait(1);
        //Red_Led_SET=0;
        //Blue_Led_SET=0;
        
    }
}
