//-----------------------------------------------------------
//  Button class handling multi-touch -- Header
//      Multi-touch: Enabled (default)
//
//  2016/03/29, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------
#include "mbed.h"
#include "Button.h"
#include "LCD_DISCO_F746NG.h"
#include "fonts.h"
#ifndef __PAGE_H
#define __PAGE_H


class Page{

    public:
        Page(LCD_DISCO_F746NG* ); //imposta la pagina base per UC
        Page(LCD_DISCO_F746NG* ,uint32_t hColor, int hThickness, uint32_t fontHColor, string HText, uint32_t fColor, int fThickness, uint32_t fontFColor, string FText); //pagina personalizzata
        
        void show();
        
        void setHeaderColor(uint32_t color){headerColor = color;}
        void setFooterColor(uint32_t color){footerColor = color;}
        void setFontHeaderColor(uint32_t color){fontHeaderColor = color;}        
        void setFontFooterColor(uint32_t color){fontFooterColor = color;}
        void setHeaderText(string text){}
        void setFooterText(string text){}
        void setHeaderThickness(int thickness){headerThickness = thickness;}
        void setFooterThickness(int thickness){footerThickness = thickness;}
        
        void drawHeader();
        void drawFooter();
        
    
    private:
        //header
        uint32_t headerColor;
        uint32_t fontHeaderColor;
        string HeaderText;
        int headerThickness;
        //footer
        uint32_t footerColor;
        uint32_t fontFooterColor;
        string FooterText;
        int footerThickness;
        
        LCD_DISCO_F746NG* ptrLCD;
        
    
};


#endif