#ifndef LED_H
#define LED_H

#include "LCD_DISCO_F746NG.h"

class LED :public LCD_DISCO_F746NG
{
    public:
        //
        LED(int radius_, uint16_t x_, uint16_t y_, uint32_t ringColor_,uint32_t onColor_,uint32_t offColor_)
        {
            radius=radius_;
            x=x_;
            y=y_;
            ringColor=ringColor_;
            onColor=onColor_;
            offColor=offColor_;
            ringDim = radius-5;
        }
    
        void Draw(){
              SetTextColor(ringColor);
              FillCircle(x, y, radius);
              SetTextColor(offColor);
              FillCircle(x, y, ringDim);
              wait(0.2);
            }
   
           
        void On(){
            SetTextColor(onColor);
            FillCircle(x, y, ringDim);
        }
        
        void Off(){
            SetTextColor(offColor);
            FillCircle(x, y, ringDim);
        }
        
        void Blink(int n){
            for(int i=0; i<n; i++){
                    On();
                    wait(0.4);
                    Off();
                    wait(0.4);
                }
        }
   
   
   
   
    protected:
        int radius;
        uint16_t x, y, ringDim;
        uint32_t ringColor, onColor, offColor;
   
   
   
   
   
   
   
   
    };



#endif