#include "mbed.h"
#include "uLCD_4DGL.h"
#include "LSM9DS1.h"

uLCD_4DGL uLCD(p13,p14,p30); // LCD (serial tx, serial rx, reset pin;)
LSM9DS1 imu(p9, p10, 0xD6, 0x3C); // Accelerometer
//Serial pc(USBTX, USBRX);

int main() {
    uLCD.baudrate(3000000);
    uLCD.printf("still working");
    imu.begin();
    imu.calibrate();
    uLCD.printf("and working");
    //uLCD.background_color(BLACK);
    uLCD.circle(64, 64, 30, WHITE);
    int ax = 64, ay = 64, radius = 8;
    uLCD.filled_circle(64, 64, radius, WHITE);
    while(1) {
        imu.readAccel();
        uLCD.current_col = 0;
        uLCD.printf("%d ", (int)imu.ax/1000);
        uLCD.filled_circle(ax, ay, radius, BLACK);
        ax = imu.ax/1000 + 64;
        ay = imu.ay/1000 + 64;
        uLCD.filled_circle(ax, ay, radius, WHITE);
        wait(.1);
    }
}