#include "mbed.h"
#include "TSISensor.h"
#include "TextLCD.h"
#include "process_signal.h"
#include "reciever.h"
#include "transmitter.h"


//RGB LED SETUP
DigitalOut Red(PTC6);
DigitalOut Blue(PTC10);
DigitalOut Green(PTC11);

Serial pc(USBTX,USBRX);

//LCD SCREEN SETUP
TextLCD lcd(PTD7, PTD6, PTA17, PTA16, PTC17, PTC16); // rs, e, d4-d7

//INITIAL PARAMETERS AND GLOBAL VARIABLES
int hit=0;
int lives=10;                       //How many lives to start game with
unsigned char data[4];
unsigned char Ah=0;
unsigned char Bh=0;
unsigned char Ch=0;
unsigned char Dh=0;
char Player='A';

//BEGIN!

int main() 
{
while(1) 
{    
    reset_array();          //At start of new game reset hits from players to 0
    
    while (lives>=0)
    {
    Blue=1;                 //Blue light always on when playing
    Red=0;                  
    Green=0;
    
    if (lives==0)
    {
    Green=1;               //Turquoise if no lives remain (effectively last life left)
    }
    
    
    lcd.cls();
    
    lcd.locate(0,0);
    lcd.printf("Player %c \n", Player);          //Print which player you are
    
    lcd.locate(0,1);
    lcd.printf("Lives left: %d \n", lives);      //Print how many lives are left
    

    //Have you been hit?
    
    int signal;                                    
    signal=Interrogate();
    hit= process_signal(signal);

                 
                lives--;
                
                if(lives<0)
                {
                goto end;        //Skip to the end (avoids read out of -1 lives)
                }
                
                //Update lives on LCD
                
                lcd.locate(0,1);
                lcd.printf("You've been hit!");
                
                //Flash to register hit
                unsigned char i;                
                for(i=0;i<4;i++)            //INCREASE i TO EXTEND TIME THAT GUN IS DISABLED!
                    {
                    Blue=0;
                    Red=1;
                    wait(0.2);
                    Red=0;
                    Blue=1;
                    wait(0.2);                  
                    }
                
    }
       
end:

Blue=0;
Green=0; 
lcd.cls();
lcd.locate(0,0);
lcd.printf(" - GAME  OVER - ...you suck");


unsigned char i;
for(i=0;i<50;i++)           //Flashing to indicate game over - INCREASE i FOR LONGER BREAK BEFORE RESET 
                    {
                    Red=1;
                    wait(0.05);
                    Red=0;
                    wait(0.05); 
                    }
                    
//Pretty green light and resetting
Green=1;  
lives= 10;
wait(2);    
Green=0;        
lcd.cls(); 
}
}