#include "mbed.h"
#include "TextLCD.h"
#include "readknobs.h"

//Declare necessary variables
extern int tempo;
extern int swing;
extern int mintempo;
extern int maxtempo;

void readknobs()        //Function Definition
{

// SWING CALCULATION

int a = sw.read() * 10;     //Make the analog read an integer from 0-10

    switch (a)              //Segmented solution to each case
    {
    case 0: swing = -150;
    case 1: swing = -150;
    case 2: swing = -100;
    case 3: swing = -60;
    case 4:                 //
    case 5:                 // Note, plenty of 0 swing to prevent accidental swing
    case 6: swing = 0;      //
    case 7: swing = 60;
    case 8: swing = 100;
    case 9: swing = 100;
    case 10: swing = 150;
    }
    
// TEMPO CALCULATION

    tempo = mintempo + (maxtempo-mintempo)*tmp.read_u16() / 65535;  //Tempo as the analog read percentage multiplied by tempo range
    
    tempo = (doubletime) ? 2*tempo : tempo;                //Double the tempo if doubletime==1
    
// DISPLAY INFO
char signature[]="x/4";
if (threetime==0)
{
signature[0]= '4';
}
else
{
signature[0]= '3';
}

char percentage = 37;

lcd.cls();
lcd.locate(0,0);
lcd.printf("%d bpm", tempo);
lcd.locate(1,0);
lcd.printf("Swing: %d %c", swing, percentage);
lcd.locate(2,0);
lcd.printf("TimeSig: %s", signature);
}