/* ----------------------------------------------------------
Informatica Industrial - Timers Avanzado

Programa donde se realizan 3 tareas por piertos:
   1) Incrementar un contador en un display de 7 segmentos
   2) Parpadear un led a cierta frecuencia
   3) Leer datos de un puerto analogico y calcular promedio
Además realiza las siguientes actividades cuando se presenta
un evento:
   1) Leer el estado de un boton y una bandera que evita que
      se manden a imprimir muchos datos y saturar la
      comunicacion serie
   2) Leer el estado de un boton y una bandera que hacen 
      cambiar el modo de operacion entre un voltimetro y un
      ohmetro.

Autor: Gerardo Carmona
Fecha: 28 / Febrero / 2014
Versión: 1.0

----------------------------------------------------------- */

#include "mbed.h"

//--- O/I Pins ----------------------------------------------
DigitalOut led_status(D13);  //Just for fun
                   //A,  B,  C,  D,  E,  F,  G
BusOut seven_segment(D2, D3, D4, D5, D6, D7, D8);
DigitalIn select(D9);
DigitalIn send_data(D10);
AnalogIn read_voltage(A0);
AnalogIn read_resistor(A2);
Timer timer;
Serial pc(USBTX, USBRX); // tx, rx

//--- Constants ---------------------------------------------
#define MAX_COUNT 15            //Max count for display
#define MIN_COUNT 0             //Min count for display
#define INCREMENT_TIME_MS 1000  //Increment display time
#define BLINK_LED_TIME_MS 250   //Blink LED
#define READ_DATA_TIME_MS 500   //Read and convert data
#define SEND_DATA_TIME_MS 500   //Time to send data to PC

//--- Variables ---------------------------------------------
int actual_time = 0;
int last_time = 0;
int count = 0;
int mode = 0;   // 0 - Read Voltaje, 1 - Read Resistence
int mili_volts[10] = {0,0,0,0,0,0,0,0,0,0};
int resistor_ohms[10] = {0,0,0,0,0,0,0,0,0,0};
int data = 0;
int reading_number = 0;
int array_index = 0;

//--- Functions Declarations --------------------------------
void increment_display(int c);
int multimeter(int flag);

//--- Main Program ------------------------------------------
int main() {
    timer.start();
    while(1) {
        actual_time = timer.read_ms();
        if (actual_time % INCREMENT_TIME_MS == 0){
            pc.printf("count: %i\n", count);
            increment_display(count);
            if (count < MAX_COUNT){
                count++;
            }else{
                count = MIN_COUNT;
            }
        }
        
        if (actual_time % BLINK_LED_TIME_MS == 0){
            led_status = !led_status;
        }
        
        if (actual_time % READ_DATA_TIME_MS == 0){
            data = multimeter(mode);
        }
        
        
        if (send_data == 1 && actual_time >= (last_time + SEND_DATA_TIME_MS)){
            if (mode == 0){
                pc.printf("Voltaje: %d mV\n", data);
            }else{
                pc.printf("no hay infomacion disponible\n");
            }
            last_time = actual_time;
        }
        
        if (select == 1 && actual_time >= (last_time + SEND_DATA_TIME_MS)){
            mode = !mode;
            last_time = actual_time;
        }
        
            
    }
}

//--- Functions --------------------------------------------
void increment_display(int c){
    switch (c){
        case 0:
            seven_segment = 63; 
            break;
        case 1:
            seven_segment = 6; 
            break;
        case 2:
            seven_segment = 91; 
            break;
        case 3:
            seven_segment = 79; 
            break;
        case 4:
            seven_segment = 102; 
            break;
        case 5:
            seven_segment = 109; 
            break;
        case 6:
            seven_segment = 125; 
            break;
        case 7:
            seven_segment = 7; 
            break;
        case 8:
            seven_segment = 127; 
            break;
        case 9:
            seven_segment = 111; 
            break;
        case 10:
            seven_segment = 119; 
            break;
        case 11:
            seven_segment = 124; 
            break;
        case 12:
            seven_segment = 57; 
            break;
        case 13:
            seven_segment = 94; 
            break;
        case 14:
            seven_segment = 121; 
            break;
        case 15:
            seven_segment = 113; 
            break;
        default:
            seven_segment = 64;
    }
}

int multimeter(int flag){
    int average = 0;
    float temp = 0;
    if (flag == 0){
        temp = read_voltage*36300;  //36300 = 1000(convert to mV) * 3.3(convert to volts) * 11(ratio)
        mili_volts[array_index] = int(temp);
        
        for (int i = 0; i <= reading_number; i++){
            average += mili_volts[i]; //sum all the values
        }
        average = average/(reading_number+1); //calulate the average
        
        /* debugging purposes
        pc.printf("index: %i, ", array_index);
        pc.printf("actual: %i, promedio: %i, ", mili_volts[array_index], average);
        pc.printf("reading number: %i\n", reading_number); */
        
        array_index++;
        if (reading_number < 9){
            reading_number++;       //max number is 9
        }
        if (array_index > 9){
            array_index = 0;        //reset array index
        }
        
    }else{
        pc.printf("falta hacer la lectura\n");
    }
    
    return average;
}

