/* 
    INSTRUCCIONES:
    Suponga que tiene 3 botones con resistencias de pull-up (A, B, C) 
    y un display de 7 segmentos de cátodo común. Realice un programa 
    que convierta de número binario a display de 7 segmentos.
*/

#include "mbed.h"

DigitalIn A(D2);
DigitalIn B(D3);
DigitalIn C(D4);
BusOut display(D5, D6, D7, D8, D9, D10, D11);

void bcd_to_7segment(int number);

bool button_A, button_B, button_C;
int number;
 
int main() {
    A.mode(PullUp);
    B.mode(PullUp);
    C.mode(PullUp);
    while(1){
        button_A = !A;
        button_B = !B;
        button_C = !C;
        number = A + B*2 + C*4; //tambien se puede number = A | B << 1 | C << 2;
        bcd_to_7segment(number);
    }   
}

void bcd_to_7segment(int number){
    switch (number){
        case 0:
            display = 63; break;
        case 1:
            display = 6; break;
        case 2:
            display = 91; break;
        case 3:
            display = 79; break;
        case 4:
            display = 102; break;
        case 5:
            display = 109; break;
        case 6:
            display = 125; break;
        case 7:
            display = 7; break;
}