#include "mbed.h"

DigitalOut F1(D13);
DigitalOut F2(D12);
DigitalOut F3(D11);
DigitalOut F4(D10);

DigitalIn A(D2);
DigitalIn B(D3);
DigitalIn C(D4);
DigitalIn D(D5);



int main() {
    while(1) {
        // F1 = A’+BCD + BD’
        F1 = !A | B&C&D | B&!D;
        // F2 = (A+B)(B’+C)(A+B+C+D)
        F2 = (A|B) & (!B|C) & (A|B|C|D);
        // F3 = ABCD+A’B’C’D’
        F3 = A&B&C&D | !A&!B&!C&!D;
        // F4 = (A’+B’+C’+D’)(A+BC)
        F4 = (!A|!B|!C|!D) & (A|B&C);
    }
}
