#include "mbed.h"
#include "MMA8451Q.h"
#include "USBMouse.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    USBMouse mouse;
    DigitalIn boton(PTA1);
    
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y;
        int value;
        
        x = acc.getAccX() * 10;
        y = acc.getAccY() * 10;
        
        value = boton;
        if (value == 1){
            mouse.click(MOUSE_LEFT);
            wait(0.5);
        }
        
        mouse.move((int)x, (int)y);
        
        wait(0.001f);
        
    }
}
