// accelerometer

#include "mbed.h"
#include "MMA8451Q.h" //library for accelerometer

#define MMA8451_I2C_ADDRESS (0x1d<<1) //Address <<1 space indicates write

int main(void) {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS); //create an object
    PwmOut rled(LED_RED);  //create 3 objects for the leds pins
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);

    while (true) {
        rled = 1 - abs(acc.getAccX()); // abs() = absolute value
        gled = 1 - abs(acc.getAccY()); // getAccY = get Y-axis value
        bled = 1 - abs(acc.getAccZ()); // Substract 1 - absolute acceleration
        wait(0.1); //wait 100ms before new readings
    }
}

