/* 
    - Descripcion -
    Mandar la lectura de un puerto analogico y mandarlo por Serie a la computadora.
    Recuerda que para Windows debes tener instalado el driver de la Freedom y un 
    programa que pueda monitorear puertos serie como Teraterm.
    
    Configura Teraterm seleccionando la opcion de Serial y selecciona el puerto COM
    que esta utilizando tu tarjeta (busca dentro del administrador de dispositivos
    el puerto COM).
    
    - AYUDA -
    Serial       : Para configurar comunicacion Serie.
    USBTX, USBRX : Configura los puertos (Envio, Recepcion).
    printf       : Comando para mandar los datos a traves del puerto COM, se requiere
                   especificar que datos, entre " " se pone texto y el tipo de 
                   variables que se desea enviar.
    %f           : Especifica que queremos mandar una variable tipo float.
    \n           : Manda un salto de linea.               
*/

#include "mbed.h"
 
Serial pc(USBTX, USBRX); // tx, rx
AnalogIn pot(A0);

float potval;

int main(){
    while(1){
        potval = pot;
        pc.printf("El valor del puerto es: %f volts\n", potval);
        wait(1);
    }

}

