 /* Copyright (c) 2011 Greg Brush
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *  This code based on:
 *  WiiChuck
 *  http://mbed.org/users/FrankWeissenborn/libraries/WiiChuck/lnae1a
 *
 *  2011-03-14
 *  Interface with 3rd Party Wii Motion Plus (alone)
 *  This has not been tried with WiiMP plugged into Wii controller or Nunchuck
 */
 
#ifndef __WIIMP_H
#define __WIICMP_H

#include "mbed.h"

#define WMP_ADDR        0xA6  // pre-init WM+ address
#define WIIEXT_ADDR     0xA4  // normal address for Wii Extensions
#define WIIMP_READLEN   0x06  //
#define I2C_ACK 0
#define I2C_READ_DELAY  1     // delay in millisec

#define YawL    0
#define RollL   1
#define PitchL  2
#define YawH    3
#define RollH   4
#define PitchH  5

class WiiMP {
public:
    bool Error;
    WiiMP(PinName data, PinName clk);
    bool Read(int* Yaw,int* Roll,int* Pitch);
private: 
    I2C _i2c;
};

#endif