#include "WiiChuk_compat.h"



WiiChuck::WiiChuck(PinName data, PinName clk):_i2c(data, clk) {
    _i2c.frequency(400000); // should work at 100000 too
    Error = true;

    // initialize Wii extension (nunchuk) based on "new way" initialization
    // http://wiibrew.org/wiki/Wiimote#The_New_Way
    // also disables need for decryption
    
    unsigned char cmd[] = {0xF0, 0x55};
    if (_i2c.write(NUNCHUCK_ADDR, (const char*)cmd, sizeof(cmd)) == I2C_ACK) {
        Error = false;
    }
    
    cmd[0] = 0xfb; cmd[1]= 0x00;
    _i2c.write(NUNCHUCK_ADDR, (const char*)cmd, sizeof(cmd));
    
    _oldC = 0;
    _oldZ = 0;
}

bool WiiChuck::Read(int* joyX,int* joyY,int* accX,int* accY,int* accZ,int* buttonC,int* buttonZ) {

    //int i;
    char readBuf[NUNCHUCK_READLEN];
    
    if (Error) {
        return false;
    }
    
    const unsigned char cmd[] = {0x00};
    if (_i2c.write(NUNCHUCK_ADDR, (const char*)cmd, sizeof(cmd)) == I2C_ACK) {
        wait(I2C_READ_DELAY);
        if (_i2c.read(NUNCHUCK_ADDR, readBuf, sizeof(readBuf)) == I2C_ACK) {
            //init values
            *joyX = 0; *joyY = 0; *accX = 0; *accY = 0; *accZ = 0; *buttonC = 0; *buttonZ = 0;
   
            /*  Decrypting not required with new initialization
            for (i = 0; i < NUNCHUCK_READLEN; ++i) {
                readBuf[i] = (readBuf[i] ^ 0x17) + 0x17;
            }
            */
            
            *joyX = readBuf[Joy_X];
            *joyY = readBuf[Joy_Y];
            *accX = readBuf[Acc_X] << 2;
            *accY = readBuf[Acc_Y] << 2;
            *accZ = readBuf[Acc_Z] << 2;

            if (readBuf[Button] & 0x01) {
                *buttonZ = 0;
            } else {
                *buttonZ = 1;
            }
            if (readBuf[Button] & 0x02) {
                *buttonC = 0;
            } else {
                *buttonC = 1;
            }
            if (readBuf[Button] & 0x04) accX += 2;
            if (readBuf[Button] & 0x08) accX += 1;
            if (readBuf[Button] & 0x10) accY += 2;
            if (readBuf[Button] & 0x20) accY += 1;
            if (readBuf[Button] & 0x40) accZ += 2;
            if (readBuf[Button] & 0x80) accZ += 1;
            return true;
        }
        else
        {
            return false;
        }
    } else {
        return false;
    }

}

void WiiChuck::start()
{
    _getValues.attach(this, &WiiChuck::getValues,0.2);
}
void WiiChuck::stop()
{
     _getValues.detach();
}

void WiiChuck::getValues()
{
    int joyX = 0;int joyY = 0;
    int accX = 0;int accY = 0;int accZ = 0;
    int buttonC = 0;int buttonZ = 0;
     
    bool read = Read(&joyX,&joyY,&accX,&accY,&accZ,&buttonC,&buttonZ);
  
    if(read)
    {
        //analyse
        if(_oldC == 0 && buttonC == 1)
        {
            _oldC = 1;
            _callback_input(BUTTON_CANCEL_VALUE);
            return;
        }
        else
        {
            _oldC = buttonC;
        }
        
        //analyse
        if(_oldZ == 0 && buttonZ == 1)
        {
            _oldZ = 1;
            _callback_input(BUTTON_OK_VALUE);
            return;
        }
        else
        {
            _oldZ = buttonZ;
        }
        
        if(joyY>160)
        {
            _callback_input(BUTTON_VOLUME_PLUS);
            return;
        }
        if(joyY<80)
        {
        
            _callback_input(BUTTON_VOLUME_MINUS);
            return;
        }
        if(joyX>160)
        {
            _callback_input(BUTTON_NEXT_VALUE);
            return;
        }
        if(joyX<80)
        {
        
            _callback_input(BUTTON_PREV_VALUE);
            return;
        }
        
    }
}
void WiiChuck::attach(pt2Func function)
{
    _callback_input = function;
}


