/*
Copyright (c) 2015 Giovanni di Dio Bruno (www.gbr1technologies.altervista.org)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/


#ifndef     __MMA8453_H__
#define     __MMA8453_H__

#include "mbed.h"

class MMA8453{
   private:
   
    //sensor address
    static const char I2C_ADDR = 0x1C << 1;
    I2C     i2c;
    
    double  convert(char * buffer);
    void    readRegisters(char address, char * buffer, int len);
    int     writeRegister(char address, char value);
    
   public:
            MMA8453(PinName sda, PinName scl);
            
    double  getX();
    double  getY();
    double  getZ();
    
    void    getXYZ(double& x, double& y, double& z);   
};   

#endif