#include "MMA8453.h"


MMA8453::MMA8453(PinName sda, PinName scl): i2c(sda,scl){
    i2c.frequency(400);
    writeRegister(0x2A, 0x01);
}
    
void MMA8453::readRegisters(char address, char* buffer, int len) {
    i2c.write(I2C_ADDR, &address, 1, true);
    i2c.read(I2C_ADDR | 1, buffer, len);
}

int MMA8453::writeRegister(char address, char value) {    
    char buffer[2] = { address, value };
    return i2c.write(I2C_ADDR, buffer, 2);
}

double MMA8453::convert(char* buffer) {
    double val = ((buffer[0] << 2) | (buffer[1] >> 6));    
    if (val > 511.0) 
        val -= 1024.0;
    return val / 512.0;
}

double MMA8453::getX() {
    char buffer[2];
    readRegisters(0x01, buffer, 2);
    return 2*convert(buffer);
}

double MMA8453::getY() {
    char buffer[2];
    readRegisters(0x03, buffer, 2);
    return 2*convert(buffer);
}

double MMA8453::getZ() {
    char buffer[2];
    readRegisters(0x05, buffer, 2);
    return 2*convert(buffer);
}

void MMA8453::getXYZ(double& x, double& y, double& z) {
    char buffer[6];
    readRegisters(0x01, buffer, 6);
    x = 2*convert(buffer);
    y = 2*convert(buffer + 2);
    z = 2*convert(buffer + 4);
}