#include "mbed.h"
#include "WirelessInterface.h"
    //Wireless Interface contains include files for the Huzzah and BT Friend
#include <string>

//Debug serial port
RawSerial pc(USBTX, USBRX);

WirelessInterface cmd(p28, p27, p26, pc, 9600);  //Comment this out to manually configure each device individually
//Huzzah cmd(p28,p27,p26,pc);
//BTFriend cmd(p28,p27,p26,pc);
DigitalOut sel(p22);
InterruptIn pb(p18);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
RawSerial dev = cmd.getLocalSerial();


bool command(const char *cmd)
{
    char result[240];
    strcpy(result,cmd);
    strcat(result,"\r\n");
    //pc.printf(result);
    led2 = !led2;
    wait(0.250);
    for (int i = 0; i<strlen(result); i++) 
    {
        
        dev.putc(result[i]);
        //pc.putc(result[i]);
    }
    wait(0.250);
    return true;
}

//Interrupt function to change the selected device to communicate with
void changeDevice()
{
    sel = !sel;
    
    char selDev[256];
    if(!sel)
        sprintf(selDev, "Huzzah WiFi Module");
    else
        sprintf(selDev, "Bluetooth Module");
        
    pc.printf("Communicating with: '%s'\r\n", selDev);
    wait(1);    //Debounce
}

int main()
{
    sel = 0;    //0 = WiFi, 1 = Bluetooth
    
    /* An external interrupt can be setup to change the sel pin during runtime */
    pb.rise(&changeDevice);
    
    /*Setting up the server to allow serial passthrough */
    command("sk = net.createConnection(net.TCP, 0)");
    wait(1);
    command("sk:on(\"receive\", function(sck, c) print(\"Received: \" .. c) end)");
    wait(1);
    command("sk:on(\"connection\", function(sck,c)");
    wait(1);
    command("end)");
    wait(1);
    command("sk:connect(5001,\"107.161.22.189\")");
    wait(1);
    //Send sk:send(STRING_HERE)
    //Received messages start with Received: 
    
    while(1) 
    {
        sleep();
    }
}