/*===================================================================
--------------------- Huzzah.cpp ----------------------
*Description

Written for:
    Georgia Institute of Technology
    ECE 4180, Final Project
    Dr. James Hamblen
    
Authors:
    Garren Boggs
    David Cox
    Anthony Jones
    Parth Patel
===================================================================*/

#include "mbed.h"
#include "Huzzah.h"

char buf[2024];
char snd[1024];
 
char ssid[32];
char pwd [32]; 
int  count,ended,timeout;
//Timer t;

Huzzah :: Huzzah(PinName tx, PinName rx, PinName rst, RawSerial dev, int baudrate) : 
    _cmd(tx, rx), _rst(rst),
#if DEBUGMODE
    _dev(USBTX, USBRX)
#else
    _dev(dev)
#endif
{
    _cmd.baud(baudrate);
    _dev.baud(baudrate);    
    _cmd.attach(this, &Huzzah::send, Serial::RxIrq);
    _dev.attach(this, &Huzzah::recv, Serial::RxIrq);
#if DEBUGMODE
    _dev.printf("Initializing the Huzzah ESP8622...\n\r");
#endif
    reset();
    ESPSetBaudrate(baudrate);
    timeout=2;
    getReply();
}

// Sets new ESP8266 baurate, change the esp.baud(xxxxx) to match your new setting once this has been executed
void Huzzah :: ESPSetBaudrate(int speed)
{
    memset(buf, '\0', sizeof(buf));
    sprintf(buf, "AT+CIOBAUD=%d\r\n", speed);
    strcpy(snd, buf);
    SendCMD();
    _dev.printf("\f\n\r-------------ESP8266 Baudrate Set-------------\n\r");
    _dev.printf("ESP Baudrate set to %d\n\r",speed);
}

/**
*
*/ 
void Huzzah :: configure(char* SSID, char* PASSWORD)
{
    ESPConfig(SSID,PASSWORD);
}

//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void Huzzah :: ESPConfig(char* SSID, char* PASSWORD)
{
    //Resets the device to clear current configuration
    reset();
    
    //Clear the current SSID and password of connection
    memset(&ssid[0], '\0', sizeof(ssid));
    memset(&pwd[0], '\0', sizeof(pwd));
    
    //Set the SSID and password of connection
    strcpy(ssid, SSID);
    strcpy(pwd, PASSWORD);
    
    
    
    wait(5);
    _dev.printf("\f---------- Starting ESP Configuration ----------\r\n\n");
        strcpy(snd,".\r\n.\r\n");
    SendCMD();
    
    wait(1);
    _dev.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"node.restart()\r\n");
    SendCMD();
    timeout=5;
    getReply();
    _dev.printf(buf);
 
    wait(2);
    _dev.printf("\n---------- Get Version ----------\r\n");
    strcpy(snd,"print(node.info())\r\n");
    SendCMD();
    timeout=4;
    getReply();
    _dev.printf(buf);
 
    wait(3);
    // Set CWMODE to 1=Station, 2=AP, 3=BOTH, Default mode=1 (Station)
    _dev.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "wifi.setmode(wifi.STATION)\r\n");
    SendCMD();
    timeout=4;
    getReply();
    _dev.printf(buf);
 
    wait(2);
    _dev.printf("\n---------- Listing Access Points ----------\r\n");
    strcpy(snd, "function listap(t)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "for k,v in pairs(t) do\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "print(k..\" : \"..v)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "end\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "end\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "wifi.sta.getap(listap)\r\n");
        SendCMD();
    
    wait(1);
    timeout=15;
    getReply();
    _dev.printf(buf);
 
    wait(2);
    _dev.printf("\n---------- Connecting to AP ----------\r\n");
    _dev.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "wifi.sta.config(\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\")\r\n");
    SendCMD();
    timeout=10;
    getReply();
    _dev.printf(buf);
 
    wait(5);
    _dev.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "print(wifi.sta.getip())\r\n");
    SendCMD();
    timeout=3;
    getReply();
    _dev.printf(buf);
 
    wait(1);
    _dev.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "print(wifi.sta.status())\r\n");
    SendCMD();
    timeout=5;
    getReply();
    _dev.printf(buf);
    _dev.printf("\n\n\n  If you get a valid (non zero) IP, ESP8266 has been set up.\r\n");
    _dev.printf("  Run this if you want to reconfig the ESP8266 at any time.\r\n");
    _dev.printf("  It saves the SSID and password settings internally\r\n");
    
    wait(10);   
    _dev.printf("\n---------- Setting up http server ----------\r\n");
    strcpy(snd, "srv=net.createServer(net.TCP)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "srv:listen(80,function(conn)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "conn:on(\"receive\",function(conn,payload)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "print(payload)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "conn:send(\"<!DOCTYPE html>\")\r\n");
        SendCMD();
        wait(1); 
        strcpy(snd, "conn:send(\"<html>\")\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "conn:send(\"</html>\")\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "end)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "conn:on(\"sent\",function(conn) conn:close() end)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "end)\r\n");
        SendCMD();
        
    wait(1);
    timeout=17;
    getReply();
    _dev.printf(buf);
    _dev.printf("\r\nDONE");
}

/**
*
*/ 
void Huzzah :: SendCMD()
{
    _cmd.printf("%s", snd);
}

/**
*
*/
void Huzzah :: getReply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended = 0;
    count = 0;
    while(!ended) {
        if(_cmd.readable()) {
            buf[count] = _cmd.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}

/**
*
*
*/
void Huzzah :: setLocalSerial(RawSerial cmd, int baud)
{
    _cmd = cmd;
    _cmd.baud(baud);
}

/**
*
*
*/
void Huzzah :: setSerialDev(RawSerial dev, int baud)
{
    _dev = dev;
    _dev.baud(baud);
}

/**
*
*
*/
RawSerial Huzzah :: getLocalSerial()
{
    return _cmd;
}

/**
*
*
*/
RawSerial Huzzah :: getSerialDev()
{
    return _dev;
}


/**
*
*
*/
void Huzzah :: reset()
{

    _rst = 0;
    wait(0.5);
    _rst = 1;
    _dev.printf("\f\n\r-------------ESP8266 Hardware Reset-------------\n\r");
}

/**
*
*
*/
void Huzzah :: baudrate(int speed)
{
    _cmd.baud(speed);
    ESPSetBaudrate(speed);
}

/**
*
*
*/
void Huzzah :: recv()
{
    while(_dev.readable()) {
        _cmd.putc(_dev.getc());
    } 
}


/**
*
*
*/
void Huzzah :: send()
{
    while(_cmd.readable()) {
        _dev.putc(_cmd.getc());
    } 
}



