/*===================================================================
--------------------- WirelessInterface.h ----------------------
*Description

Written for:
    Georgia Institute of Technology
    ECE 4180, Final Project
    Dr. James Hamblen
    
Authors:
    Garren Boggs
    David Cox
    Anthony Jones
    Parth Patel
===================================================================*/

#include "Huzzah.h"
#include "BTFriend.h"

#ifndef __WirelessInterface_H__
#define __WirelessInterface_H__

#ifndef DEBUGMODE
#define DEBUGMODE 1
#endif

class WirelessInterface
{
public:
    WirelessInterface(PinName tx, PinName rx, PinName rst, RawSerial dev, int baudrate);    
    void resetAll();
    void resetWifi();
    void resetBluetooth();
    void shutdownWifi();    //Implement
    void shutdownBluetooth();//Implement
    void powerWifi();//Implement
    void powerBluetooth();//Implement
    void setLocalSerial(RawSerial cmd, int baud = 9600);
    void setSerialDev(RawSerial dev, int baud = 9600);
    void baudrate(int speed);
    RawSerial getLocalSerial();
    RawSerial getSerialDev();
    void send();
    void recv();
    
private:
    Huzzah _cmdwifi;
    BTFriend _cmdbt;
    DigitalOut _rst;

};
#endif 