/*===================================================================
--------------------- WirelessInterface.cpp ----------------------
*Description

Written for:
    Georgia Institute of Technology
    ECE 4180, Final Project
    Dr. James Hamblen
    
Authors:
    Garren Boggs
    David Cox
    Anthony Jones
    Parth Patel
===================================================================*/

#include "mbed.h"
#include "WirelessInterface.h"

WirelessInterface :: WirelessInterface(PinName tx, PinName rx, PinName rst, RawSerial dev, int baudrate) : 
    _cmdwifi(tx, rx, rst, dev, baudrate), _cmdbt(tx, rx, rst, dev, baudrate), _rst(rst)
{}

/**
*
*
*/
void WirelessInterface :: setLocalSerial(RawSerial cmd, int baud)
{
    _cmdwifi.setLocalSerial(cmd,baud);
    _cmdbt.setLocalSerial(cmd,baud);
}

/**
*
*
*/
void WirelessInterface :: setSerialDev(RawSerial dev, int baud)
{
    _cmdwifi.setSerialDev(dev,baud);
    _cmdbt.setSerialDev(dev,baud);
}

/**
*
*
*/
RawSerial WirelessInterface :: getLocalSerial()
{
    return _cmdwifi.getLocalSerial();
}

/**
*
*
*/
RawSerial WirelessInterface :: getSerialDev()
{
    return _cmdwifi.getSerialDev();
}




/**
*
*
*/
void WirelessInterface :: resetAll()
{
    _cmdwifi.reset();
    _cmdbt.reset();
}

/**
*
*
*/
void WirelessInterface :: resetWifi()
{
    _cmdwifi.reset();
}

/**
*
*
*/
void WirelessInterface :: resetBluetooth()
{
    _cmdbt.reset();
}

/**
*
*
*/
void WirelessInterface :: baudrate(int speed)
{
    _cmdwifi.baudrate(speed);
    _cmdbt.baudrate(speed);
}

void WirelessInterface :: recv()
{
    _cmdwifi.recv();
}

void WirelessInterface :: send()
{
    _cmdwifi.send();
}



