/*===================================================================
--------------------- BTFriend.h ----------------------
*Description

Written for:
    Georgia Institute of Technology
    ECE 4180, Final Project
    Dr. James Hamblen
    
Authors:
    Garren Boggs
    David Cox
    Anthony Jones
    Parth Patel
===================================================================*/

#ifndef __BTFriend_H__
#define __BTFriend_H__

#ifndef DEBUGMODE
#define DEBUGMODE 1
#endif

class BTFriend
{
public:
    BTFriend(PinName tx, PinName rx, PinName rst, RawSerial dev, int baudrate = 9600);    
    void reset();
    void setLocalSerial(RawSerial cmd, int baud = 9600);
    void setSerialDev(RawSerial dev, int baud = 9600);
    void baudrate(int speed);
    RawSerial getLocalSerial();
    RawSerial getSerialDev();
    
protected:
    RawSerial _cmd;
    RawSerial _dev;
    void send();
    void recv();
    
private:
    DigitalOut _rst;
};
#endif 