/*===================================================================
--------------------- BTFriend.cpp ----------------------
*Description

Written for:
    Georgia Institute of Technology
    ECE 4180, Final Project
    Dr. James Hamblen
    
Authors:
    Garren Boggs
    David Cox
    Anthony Jones
    Parth Patel
===================================================================*/

#include "mbed.h"
#include "BTFriend.h"

BTFriend :: BTFriend(PinName tx, PinName rx, PinName rst, RawSerial dev, int baudrate) : 
    _cmd(tx, rx), _rst(rst),
#if DEBUGMODE
    _dev(USBTX, USBRX)
#else
    _dev(dev)
#endif
{
    _cmd.baud(baudrate);
    _dev.baud(baudrate);    
    _cmd.attach(this, &BTFriend::send, Serial::RxIrq);
    _dev.attach(this, &BTFriend::recv, Serial::RxIrq);
#if DEBUGMODE
    _dev.printf("Initialization of Bluetooth LE UART Friend complete!\n\r");
#endif
}

/**
*
*
*/
void BTFriend :: setLocalSerial(RawSerial cmd, int baud)
{
    _cmd = cmd;
    _cmd.baud(baud);
}

/**
*
*
*/
void BTFriend :: setSerialDev(RawSerial dev, int baud)
{
    _dev = dev;
    _dev.baud(baud);
}

/**
*
*
*/
RawSerial BTFriend :: getLocalSerial()
{
    return _cmd;
}

/**
*
*
*/
RawSerial BTFriend :: getSerialDev()
{
    return _dev;
}


/**
*
*
*/
void BTFriend :: reset()
{
    _rst = 0;
    wait(0.5);
    _rst = 1;
    _dev.printf("\f\n\r-------------Bluetooth LE UART Friend Hardware Reset-------------\n\r");
}

/**
*
*
*/
void BTFriend :: baudrate(int speed)
{
    _cmd.baud(speed);
}

/**
*
*
*/
void BTFriend :: recv()
{
    while(_dev.readable()) {
        _cmd.putc(_dev.getc());
    } 
}


/**
*
*
*/
void BTFriend :: send()
{
    while(_cmd.readable()) {
        _dev.putc(_cmd.getc());
    } 
}




