/*===================================================================
--------------------- Huzzah.h ----------------------
*Description

Written for:
    Georgia Institute of Technology
    ECE 4180, Final Project
    Dr. James Hamblen
    
Authors:
    Garren Boggs
    David Cox
    Anthony Jones
    Parth Patel
===================================================================*/

#ifndef __Huzzah_H__
#define __Huzzah_H__

#ifndef DEBUGMODE
#define DEBUGMODE 1
#endif

#include <string>

class Huzzah
{
public:
    Huzzah(PinName tx, PinName rx, PinName rst, RawSerial dev, int baudrate);   
    void configure(char* SSID, char* PASSWORD); 
    void reset();
    void setLocalSerial(RawSerial cmd, int baud = 9600);
    void setSerialDev(RawSerial dev, int baud = 9600);
    void baudrate(int speed);
    RawSerial getLocalSerial();
    RawSerial getSerialDev();
    void send();
    void recv();
    
protected:
    RawSerial _cmd;
    RawSerial _dev;
    void ESPConfig(char* SSID, char* PASSWORD);
    void ESPSetBaudrate(int speed);
    void SendCMD();
    void getReply();
    
private:
    DigitalOut _rst;
    Timer t;
};
#endif