// el código de la aplicación Android está accesibl en https://github.com/gorkabueno/NeurGai

//#define DEBUG
#include "mbed.h"
#include "WiflyInterface.h"

#if (defined(DEBUG))
#define DBG(x, ...) std::printf("[neurGAI : DBG]"x"\r\n", ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[neurGAI : WARN]"x"\r\n", ##__VA_ARGS__);
#define ERR(x, ...) std::printf("[neurGAI : ERR]"x"\r\n", ##__VA_ARGS__);
#else
#define DBG(x, ...)
#define WARN(x, ...)
#define ERR(x, ...)
#endif

#define ECHO_SERVER_PORT   7

WiflyInterface wifly(D14, D15, D5, LED1, "NeurGai", "neurGai2016", WPA);

Ticker medidor;

AnalogIn sonda(A2);                     // la sonda amperimétrica debe conectarse entre los pines A2 y PTE30
AnalogOut salida_offset(PTE30);

int frecuencia_muestreo = 5000;         // con 8000 Hz hace bien el muestreo, pero el volcado del debug no es completo
int numero_muestra = 0;
float valor_muestra;
float v_offset = 0;
float v_offset_medido = 0;
float potencia = 0;
float potencia_medida = 0;
float potencia_230V =0;
float corriente_medida = 0;
bool medido = false;
bool medido_y_enviado = false;

float pendiente = 201.206437;
float offset = 0;
    
int num_medida = 0;

TCPSocketServer server;
TCPSocketConnection client;

char buffer[256];       // string con los datos


void medir()
{
    numero_muestra++;
    valor_muestra = sonda.read();
    v_offset = v_offset + valor_muestra;
    potencia = potencia + pow((valor_muestra - v_offset_medido), 2);
    if (numero_muestra == frecuencia_muestreo)  // hemos llegado a un segundo
    {
        medidor.detach();
        potencia_medida = potencia / frecuencia_muestreo;
        corriente_medida = sqrt(potencia_medida);
        v_offset_medido = v_offset / frecuencia_muestreo;
        v_offset = 0;
        potencia = 0;
        numero_muestra = 0;
        medido = true;
        potencia_230V = (corriente_medida * pendiente + offset) * 230;
        sprintf(buffer, "#%i&%f*\n", num_medida, potencia_230V);
        DBG("%s %i", buffer, strlen(buffer));
        int numDatosEnviados = client.send_all(buffer, strlen(buffer));
        medido = false;
        num_medida++;
        medido_y_enviado = true;
        DBG("datos enviados : %i", numDatosEnviados);
    }
}

int main (void)
{
    DBG("Empezando...");
    wifly.init(); // use DHCP
    while (!wifly.connect()); // join the network
    DBG("\nLa direccion IP es %s", wifly.getIPAddress());
 
    server.bind(ECHO_SERVER_PORT);
    server.listen();
 
    DBG("\nEsperando conexion...");
    server.accept(client);
    DBG("\nServidor aceptado...");
    wait(1);    //si no se le mete un pequeño retardo, se queda colgado. También vale con el DBG anterior
    
    //configura el offset de voltaje a sumar a la sonda
    salida_offset = 0.5;
    
    while (true) {
        DBG("Esperando dato...");
        int n = client.receive(buffer, sizeof(buffer));
        if (n <= 0) continue;
        DBG("Recibido dato: %s Longitud %i", buffer, n);
        buffer[n] = 0;
        if (strcmp(buffer, "Pot?\n") == 0) {
            // activa el muestreo
            medido_y_enviado = false;
            medidor.attach(&medir, 1.0/frecuencia_muestreo);
        }
            
        // spin in a main loop. medidor will interrupt it to call medir
        while (!medido_y_enviado) 
            wait(.1);
    }
}