// la App neurGAI y más información en: http://www.ehu.eus/ehusfera/neurgai/

#include "mbed.h"
#include "BluetoothSerial.h"        // en esta librería se ha modificado la clase Serial a SoftSerial para permitir 
                                    // la comunicación con Seeed Bluetooth Shield a través de SoftSerial sin utilizar una UART del micro
                                    
                                    //para habilitar conexión serie con linux, ejecutar:
                                    // sudo rfcomm bind /dev/rfcomm0 [MAC address] 1
                                    // sudo putty

Ticker medidor;

AnalogIn sonda(A2);                     // la sonda amperimétrica debe conectarse entre los pines A2 y PTE30
AnalogOut salida_offset(PTE30);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

BluetoothSerial serialBluetoothShield(D5, D4);       // TX, RX      Comunicación con Seeed-Bluetooth-Shield
//Serial pc(USBTX, USBRX); // tx, rx

int frecuencia_muestreo = 5000;
int numero_muestra = 0;
float valor_muestra;
float v_offset = 0;
float v_offset_medido = 0;
float potencia = 0;
float potencia_medida = 0;
float potencia_230V =0;
float corriente_medida = 0;
bool medido = false;

void medir()
{
    numero_muestra++;
    valor_muestra = sonda.read();
    v_offset = v_offset + valor_muestra;
    potencia = potencia + pow((valor_muestra - v_offset_medido), 2);
    if (numero_muestra == frecuencia_muestreo)  // hemos llegado a un segundo
    {
        potencia_medida = potencia / frecuencia_muestreo;
        corriente_medida = sqrt(potencia_medida);
        v_offset_medido = v_offset / frecuencia_muestreo;
        v_offset = 0;
        potencia = 0;
        numero_muestra = 0;
        led3 = !led3;   // conmuta LED azul
        medido = true;
    }
}

void flushSerialBuffer()
{
    char char1;
    while (serialBluetoothShield.readable()) {
        char1 = serialBluetoothShield.getc();
    }
    return;
}

int main() {
    //pc.printf("Apaga los leds\r\n");
    led1 = 1;   // led rojo apagado
    led2 = 1;   // led verde apagado
    led3 = 1;   // led azul apagado
    
    //configura el offset de voltaje a sumar a la sonda
    //pc.printf("Configura el offset de voltaje a sumar a la sonda\r\n");
    salida_offset = 0.5;
    float pendiente = 201.206437;
    float offset = 0;
    
    //apaga todos los LEDs
    led1 = 0;   // led rojo encendido
    led2 = 1;   // led verde apagado
    led3 = 1;   // led azul apagado
    
    //configura el Bluetooth Shield
    //pc.printf("Configura el Bluetooth Shield\r\n");
    serialBluetoothShield.setup();
    serialBluetoothShield.slave("neurGAI");  // default PIN code: 0000
    wait(2);
    
    led1 = 1;   // rojo apagado
    led3 = 0;   // azul encendido
    
    serialBluetoothShield.connect();
    wait(2);
    
    led3 = 1;   // azul apagado
    led2 = 0;   // verde encendido
    
    flushSerialBuffer();
    wait(2); // This delay is required.
    
    while (!serialBluetoothShield.writeable());  // espera a que se pueda escribir
    led2 = 1;   // apaga el led verde
    wait(1);
    
    // asigna la función medir al temporizador con intervalo 200 us
    //pc.printf("Asigna la funcion medir al temporizador con intervalo 200 us\r\n");
    medidor.attach(&medir, 1.0/frecuencia_muestreo);
 
    // spin in a main loop. medidor will interrupt it to call medir
    float t = 0;
    int tiempo = 0;
    while(1)
    {
        if (medido)
        {
            medidor.detach();
            potencia_230V = (corriente_medida * pendiente + offset) * 230;
            serialBluetoothShield.printf("#%i€%f*\r\n", tiempo, potencia_230V);
            //pc.puts("Dato enviado\r\n");
            medido = false;
            t = t + 1;
            tiempo++;
            medidor.attach(&medir, 1.0/frecuencia_muestreo);
        }
    }
}