#include "mbed.h"
#include "EAQVGAOLED.h"

Serial pc(USBTX, USBRX); // tx, rx

int main() {
    EAQVGAOLED display = EAQVGAOLED(p5, p6, p7, p8, p9, p10);
    
    display.background(BLACK);
    display.foreground(DARK_GRAY);
    display.cls();

    bool inEscape = false;  // Flag, set when in an escape sequence
    bool inCursor = false;  // Flag, set when in a cursor sequence
    
    // Loop drawing characters from USB onto the display
    while(1) {
        
        if (pc.readable()) {
            char inChar = pc.getc();
            // The terminal sends escape sequences for cursor keys,
            // these need to be converted to control characters
            if (inCursor) {
                switch(inChar) {
                case 'A':
                    display.putc(CURSOR_UP);
                    break;
                case 'B':
                    display.putc(CURSOR_DOWN);
                    break;
                case 'C':
                    display.putc(CURSOR_RIGHT);
                    break;
                case 'D':
                    display.putc(CURSOR_LEFT);
                    break;
                default:
                    display.putc(inChar);
                    break;
                }
                inCursor = false;
            }
            else if (inEscape) {
                if (inChar == 91) {
                    inCursor = true;
                }
                else {
                    display.putc(inChar);
                }
                inEscape = false;
            }
            else {
                switch (inChar) {
                case '+':
                    display.backlightControl(true);
                    break;
                case '-':
                    display.backlightControl(false);
                    break;
                case 27:
                    inEscape = true;
                    break;
                default:
                    display.putc(inChar);
                    break;
                }
            }
            pc.printf("Got char %d, inEscape: %d, inCursor: %d\r\n", inChar, inEscape, inCursor);

        }
    }
}
