#include "mbed.h"
#include "BME280.h"

Serial pc(USBTX, USBRX);
Serial nextion(PA_0,PA_1);//tx,rx

BME280 sensor(PB_9, PB_8);//sda,scl

PwmOut led(PC_8);

DigitalOut led1(PA_5);

Ticker ticker;

InterruptIn tipkalo(PC_13);

void ledON()
{
    led.period(0.5);//1/2s
    led=0.75;//75%dc
    }
    
void ledOFF()
{
    led.period(0.5);//1/2s
    led=0.0;//0%dc
    }
    
    
void PCprint()
    {
        pc.printf("%s\n", "Zaba guti rodu");
    }


 
int main()
{
     ticker.attach(&PCprint,5);
     
    nextion.baud(115200);

    int64_t vrijeme = 1614624710;
    set_time(vrijeme);
    

    while(1) {

        tipkalo.rise(&ledON);
        tipkalo.fall(&ledOFF);
        
       

        time_t seconds = time(NULL);
        char buffer[16];
        char buffer2[16];
        char buffer3[16];
        strftime(buffer, 16, "%H:%M:%S", localtime(&seconds));
        strftime(buffer2, 16, "%A,", localtime(&seconds));
        strftime(buffer3, 16, "%d %b %C", localtime(&seconds));
       // pc.printf("%s\n%s\n%s\n\n", buffer,buffer2,buffer3);
        nextion.printf("time.txt=\"%s\"%c%c%c",buffer,0xFF,0xFF,0xFF);
        nextion.printf("dan.txt=\"%s\"%c%c%c",buffer2,0xFF,0xFF,0xFF);
        nextion.printf("datum.txt=\"%s\"%c%c%c",buffer3,0xFF,0xFF,0xFF);
        nextion.printf("temp.txt=\"%2.1f %cC\"%c%c%c",sensor.getTemperature(),176,0xFF,0xFF,0xFF);
        nextion.printf("vlaga.txt=\"%2.1f %c\"%c%c%c",sensor.getHumidity(),37,0xFF,0xFF,0xFF);
        nextion.printf("tlak.txt=\"%4.1f hPa\"%c%c%c",sensor.getPressure(),0xFF,0xFF,0xFF);
        
        
       

        //pc.printf("%2.2f degC, %04.2f hPa, %2.2f %%\n", sensor.getTemperature(), sensor.getPressure(), sensor.getHumidity());
        wait(0.25);
         
    }
}
