/*
 * wave1: wave test generator
 *
 */

#include "mbed.h"

DigitalOut led1(LED1);
//DigitalOut led2(LED2);
//DigitalOut led3(LED3);
//DigitalOut led4(LED4);

DigitalOut osc1(p21);
//PwmOut led1(LED1);

Serial pc(USBTX,USBRX);

Ticker oscTick1;

// ---------------------------------------------------------------------------
#if 1
int oscData[] = { 1,1,1,0,0,0,0 };
#endif
#if 0
// DMFM
int oscData[] = { 0,1,1,0,0,0,0,1,1,1,0,0,0,1,1,0,0,0,0,1,1,1,0,0, 
                  1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,
                  1,1,0,0,1,1,0,0,1,1,0,0,
                  1,1,1,0,0,0,1,1,1,0,0,0
                };
#endif
#if 0
// Manchester
int oscData[] = { 0,1,0,1,0,0,1,1,0,0,1,1,0,1,0,1,0,1,0,
                  0,1,1,0,1,1,0,0,1,0,0,1,0,0,
 };
#endif
                
const int dx_max = sizeof(oscData)/sizeof(oscData[0]);
int dx = 0;

// ---------------------------------------------------------------------------

enum { RESET=0, SCRAMBLE, DESCRAMBLE };
int scramble1(int b, int func) {
    static int crc = 0; // 7 bit
    int fb;
    int op;

    b = !!b;

    fb = !!(crc & 0x40) ^ !!(crc & 0x08);
    crc <<= 1;
    op = b ^ fb;

    switch(func) {
    case SCRAMBLE:
        crc |= op;
        break;
    case DESCRAMBLE:
        crc |= b;
        break;
    case RESET:
        op = 0;
        crc = 0;
        break;
    } // switch - op

    return !!op;

} // scramble1

// ---------------------------------------------------------------------------

int nrz() {
    static int c = 0;
    static int b = 0;
    static int op = 0;

    if(c == 0) {
        // bit start
        b = scramble1(1,SCRAMBLE);
        op = b; // set data
    }
    else {
        // bit centre
        // same data
    }
    
    if(++c > 1) c = 0;

    return op;
} // nrz

int nrzi() {
    static int c = 0;
    static int b = 0;
    static int op = 0;

    if(c == 0) {
        // bit start
        b = scramble1(1,SCRAMBLE);
    }
    else {
        // bit centre
        if(b == 1) op = !op; // flip if 1
    }
    
    if(++c > 1) c = 0;
    
    return op;
} // nrzi

int man() {
    static int c = 0;
    static int b = 0;
    static int op = 0;

    if(c == 0) {
        // bit start
        int d = rand()&1;
        b = scramble1(d,SCRAMBLE);
        op = !b; // setup for transition
    }
    else {
        // bit centre
        // transition: +ve=1, -ve=0
        op = b; // transition direction represents bit sense
    }
    
    if(++c > 1) c = 0;

    return op;
} // man

int dman() {
    static int c = 0;
    static int b = 0;
    static int op = 0;

    if(c == 0) {
        // bit start
        int d = rand()&1;
        b = scramble1(d,SCRAMBLE);
        if(b == 1) op = !op; // flip if 1
    }
    else {
        // bit centre
        op = !op; // flip always
    }
    
    if(++c > 1) c = 0;

    return op;
} // dman

int dmfm() {
    static int c = 0;
    static int b = 0;
    static int b1 = 0;
    static int op = 0;

    
    if(c == 0) {
        // bit start
        int d = rand()&1;
        b = scramble1(d,SCRAMBLE);
        if(b1 == 0 && b == 0) op = !op; // flip if 2 zeros
        b1 = b;
    }
    else {
        // bit centre
        if(b == 1) op = !op; // flip if 1
    }

    if(++c > 1) c = 0;
    
    return op;
} // dmfm

// ---------------------------------------------------------------------------

void oscOut1() {
    osc1 = man();
    //osc1 = oscData[dx++];
    if(dx >= dx_max) dx = 0; 
}

// ---------------------------------------------------------------------------

int main() {

    scramble1(0,RESET);


    osc1 = 0;
    oscTick1.attach_us(&oscOut1, 500); // chip period
    

//    led1.period(1);
//    led1.write(50);

    pc.printf("\n\rStart: wave1\n\r");
    
    while (1) {
        led1 = 1;
        wait(0.25);
        led1 = 0;
        wait(0.25);
//
//        pc.printf(".");
//
    } // while

} // main

// ---------------------------------------------------------------------------

