#include "mbed.h"

DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);

int main() {

    pc.printf("rtc1\n\r");
    
    for(;;) {
    
    time_t seconds = time(NULL);

    char buffer[32];
    strftime(buffer, 32, "%I:%M %p\n\r", localtime(&seconds));
    printf("Time as a custom formatted string = %s", buffer);


    
    pc.printf("cmd:");
    int c = pc.getc();
    pc.printf("cmd=%d\n\r", c);

    switch(c) {    
    case 's':
        pc.printf("set time\n\r", c);
        // setup time structure for Wed, 28 Oct 2009 11:35:37
        struct tm t;
        t.tm_sec  = 00;    // 0-59
        t.tm_min  = 51;    // 0-59
        t.tm_hour = 22;   // 0-23
        t.tm_mday = 20;   // 1-31
        t.tm_mon  = 8;     // 0-11
        t.tm_year = 111;  // year since 1900
    
        // convert to timestamp and display (1256729737)
        time_t seconds = mktime(&t);
        set_time(seconds);
        break;
        
    case 'q':
        pc.printf("exit\n\r", c);
        exit(0);
    
    } // switch

    } // for - evers

} // main

