/*
 * humidity1
 *
 */

/*
+5 --------
    |
    |
   +-+
   | |      |\
   | |->----|+\
   | |      |  \--+----+------
   +-+   +- |-/   |    |
    |    |  |/    |   +-+
    |    +--------+   | |
0v ------             +_+
                       |--------
                      +-+
                      | |
                      +-+
                       |



*/ 

#include "mbed.h"

DigitalOut myled(LED1);

AnalogIn hum(p20);
AnalogIn ref(p19);
AnalogIn tst(p18);

//Timer timer;


int main() {
    float av0 = 0.0;
    float alpha = 0.2;

    printf("\rhumidity1: %u %u\n\r", sizeof(unsigned long long), sizeof(uint64_t) );

    // decimation and downsamplig to reduce noise and increment resolution

    while(1) {
        
        //   32 - ? 8081
        //   64 - 8 8082
        //  128 - 6 807d
        //  256 - 4 8071
        //  512 - 2 805e
        // 1024 - .3 803f
        // 2048 - ? 8014
        // 4096 - ? 7fe8
        // 8192 - ? 7fca
        // 16384 - ? 7fba
        // 32768 - ? 7fb2
        // 65536 - ? 7faf
        // 131072 - ? 7fad
        
        // Sample values and their differences
        // 7FB7 7FC7 7FD7 7FE7 7FF7 8008 8018 8028
        //    10   10   10   10   11   10   10
        
        // Max conversion rate: 14KHz (~70us)
        // ToDo        
        // many samples to create new data set
        // different sampling frequencies, see if effect same
        //   measure raw sampling freq
        // fourier analysis
        // freq distribution
        // overall and diff sized moving avg to see if effect is due to software.overflow or noise in data
        // what does graph do at even larger sample sizes
        // is there a temp drift?
        
        
        //unsigned long long t = 0; // uint64_t
        uint64_t t = 0;
        uint64_t n = 1000; // 128/4096
        //timer.start();
        //float b1 = timer.read();
        //int begin = timer.read_ms();
        for(int i=0; i<n; ++i) {
            //uint16_t v = tst.read_u16();
            //uint64_t v = tst.read_u16();
            uint64_t v = ref.read_u16();
            //v >>= 4; // back to 12bits
            
            t += v;
#if 0            
            switch((v>>4)&0x01) {
            case 0: wait_us(7); break;
            case 1: wait_us(17); break;
            default: printf("?");
            } // switch
#endif            
        } // for 
        //int end = timer.read_ms();
        //float e1 = timer.read();
        //printf("timer: %d %f %f\n\r", end-begin, e1-b1, (float)n*1000.0/(float)(end-begin) );

        uint64_t x = t / n;
        //t = t/(float)n;
        
        printf("%llu\n\r", x);
        //printf("%.0f\n\r", t);
        
        //wait(4); // <<<<<<<<
        
        //wait_us(31);
    }

    while(1) {
    
        // read many times to remove noise
        int n = 1000;
        float h = 0.0;
        float r = 0.0;
        float v = 0.0;
        for(int i=0; i<n; ++i) {
            float h1, r1;
            h1 = hum.read();
            r1 = ref.read();
            h += h1;
            r += r1;
            //v += 5.0*h1/r1; // convert to 5v reference
            wait_us(100);
        }
        h /= n;
        r /= n;
        //v /= n;
        
        v = 5.0*h/r; // convert to 5v reference

        
        // Exponential Moving Average
        float av = av0 + alpha*(v-av0);
        av0 = av;
        
        // scale to humidity%
        float m = (av-0.8)/3.0*100.0;
                
        printf("h=%1.4f r=%1.4f %1.4fv %1.4fv %3.2f%%\n\r", h, r, v, av, m );
    
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.8);
        
    } // while
    
} // main

