/*
 * gps1 
 *
 *      http://www.sparkfun.com/products/9133
 *      http://www.sparkfun.com/datasheets/GPS/Modules/Skytraq-Venus634FLPx_DS_v051.pdf
 *      http://www.sparkfun.com/datasheets/GPS/Modules/AN0003_v1.4.14_FlashOnly.pdf
 *
 */
 
#include "mbed.h"

DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);
Serial gps(p9,p10); // tx, rx


volatile unsigned char buff[128];
volatile int bx = 0;
volatile int rdy = 0;

unsigned char chk = 0;

void rxgps(void) {
    //while(gps.readable()) {
        int c = gps.getc();
        pc.putc(c);
        if(c == '$') {
            bx = 0;
            chk = 0;
        }
        else {
            if(c == '*') {
                pc.printf("%02X=", chk);
            }
            else {
                chk ^= (unsigned char)c;
            }
        }
        buff[bx++] = c;
        if(c == '\n') rdy = 1;
        //if(c == '\n') pc.putc('\r');
        //if(c == '\r') pc.putc('\n');
    //} // while
} // rxgps

int main() {

    // pc.baud must be >= gps.baud
    pc.baud(115200);

    pc.printf("gps1\n\r");

    gps.baud(38400); // 9600, 19200, 38400, 57600, 115200
    gps.format(8,Serial::None,1);
    
    gps.attach(&rxgps, Serial::RxIrq);

// GGA - Global Positioning System Fix Data
//  GPGGA,hhmmss.sss,ddmm.mmmm,a,dddmm.mmmm,a,x,xx,x.x, x.x,M,,,,     xxxx*hh<CR><LF>
// $GPGGA,184538.245,5105.0363,N,00109.9405,W,1,09,1.1,90.4,M,48.7,M,,0000*76

// GLL – Latitude/Longitude
//  GPGLL,ddmm.mmmm,a,dddmm.mmmm,a,hhmmss.sss,A,a*hh<CR><LF>
// $GPGLL,5105.0363,N,00109.9405,W,184538.245,A,A*4C

// GSA – GNSS DOP and Active Satellites
//  GPGSA,A,x,xx,xx,xx,xx,xx,xx,xx,xx,xx,xx,xx,xx,x.x,x.x,x.x*hh<CR><LF>
// $GPGSA,A,3,19,08,06,18,16,22,24,07,11,  ,  ,  ,2.0,1.1,1.7*3F

// GSV – GNSS Satellites in View
//  GPGSV,x,x,xx,xx,xx,xxx,xx,…,xx,xx,xxx,xx                        *hh<CR><LF>
// $GPGSV,3,1,12,19,77,295,20,03,66,137,14,22,55,098,32,06,53,125,33*79
// $GPGSV,3,2,12,18,31,053,19,11,30,261,32,16,27,183,24,24,19,246,24*7F
// $GPGSV,3,3,12,08,15,301,36,07,10,275,27,21,06,069,09,15,05,019,*78

// RMC – Recommended Minimum Specific GNSS Data
//        time                                               date  
//  GPRMC,hhmmss.sss,A,dddmm.mmmm,a,dddmm.mmmm,a,x.x,x. x,   ddmmyy,,,a*hh<CR><LF>
// $GPRMC,184538.245,A,5105.0363, N,00109.9405,W,000.0,243.1,210811,,,A*74

// VTG – Course Over Ground and Ground Speed
//  GPVTG,x.x,  T,,M,x.x,  N,x.x,  K,a*hh<CR><LF>
// $GPVTG,243.1,T,,M,000.0,N,000.0,K,A*09


    for(;;) {
        //int c = gps.
        //wait_us(10);
        
        int px = 0;
        while(!rdy); // wait for gps buffer
        
    } // for - ever
    
} // main
