/*
 * eth1
 *
 * http://mbed.org/cookbook/Ethernet
 *
 */

#include "mbed.h"

#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "ipaddr.h"
#include "host.h"


EthernetNetIf eth;


DigitalOut myled(LED1);

char* sockErr(int err, int flag=0) {
    static char buff[32];

    if(flag == 0 && err == TCPSOCKET_OK) ///<Success
        return "TCPSOCKET_OK";
        
    switch(err) {
    case TCPSOCKET_SETUP: ///<TCPSocket not properly configured
        return "TCPSOCKET_SETUP";
    case TCPSOCKET_TIMEOUT: ///<Connection timed out
        return "TCPSOCKET_TIMEOUT";
    case TCPSOCKET_IF: ///<Interface has problems, does not exist or is not initialized
        return "TCPSOCKET_IF";
    case TCPSOCKET_MEM: ///<Not enough mem
        return "TCPSOCKET_MEM";
    case TCPSOCKET_INUSE: ///<Interface / Port is in use
        return "TCPSOCKET_INUSE";
    case TCPSOCKET_EMPTY: ///<Connections queue is empty
        return "TCPSOCKET_EMPTY";
    case TCPSOCKET_RST:
        return "TCPSOCKET_RST";
    }
    
    sprintf(buff, "%d", err);
    
    return buff;
} // sockErr

int main() {

    printf("eth1\n\r");

    EthernetErr etherr = eth.setup();
    printf("etherr=%d\n\r", etherr);
    
    
    TCPSocket sock;
    TCPSocketErr sockerr;
    
#if 0
    // Send/recv
    
    IpAddr ip(209,85,147,106); // google.com
        
    Host host(ip,80,"google.com");
    
    sockerr = sock.connect(host);
    printf("connect=%s\n\r", sockErr(sockerr));
    
    int len = sock.send("GET /\n\r", 7);
    printf("send=%s\n\r", sockErr(len,1));
    
    char buff[1024];
    len = sock.recv(buff, sizeof(buff));
    printf("recv=%s\n\r", sockErr(len,1));
#endif

#if 1    
    // Listener
    
    Host me(eth.getIp(), 80, "mbed");
    sockerr = sock.bind(me);
    printf("bind=%s\n\r", sockErr(sockerr));
    
    sockerr = sock.listen();
    printf("listen=%s\n\r", sockErr(sockerr));
    
    Host client;
    TCPSocket* pNewTcpSocket;
    sockerr = sock.accept(&client, &pNewTcpSocket);
    printf("accept=%s\n\r", sockErr(sockerr));
#endif

} // main

// == end ==
