#include <stdint.h>

#include "xml_data.h"
#include "kernel/circular_buffer.h"
#include "kernel/ports.h"

port_t p_yellow_toggler[1] = {{
    .is_queuing_port = true,
    .q_buf = {
        .WAITING_PROCESSES = 0,
        .PORT_DIRECTION = SOURCE,
        Q_MESSAGE_BUFFER(32, 32),
    },
    .portname = "yellow_print",
},};

port_t p_red_toggler[1] = {{
    .is_queuing_port = true,
    .q_buf = {
        .WAITING_PROCESSES = 0,
        .PORT_DIRECTION = SOURCE,
        Q_MESSAGE_BUFFER(32, 32),
    },
    .portname = "red_print",
},};

port_t p_stio_sys[1] = {{
    .is_queuing_port = true,
    .q_buf = {
        .WAITING_PROCESSES = 0,
        .PORT_DIRECTION = DESTINATION,
        Q_MESSAGE_BUFFER(32, 32),
    },
    .portname = "sys_stio",
},};

port_t p_evil[1] = {{
    .is_queuing_port = true,
    .q_buf = {
        .WAITING_PROCESSES = 0,
        .PORT_DIRECTION = DESTINATION,
        Q_MESSAGE_BUFFER(1, 1),
    },
    .portname = "temp",
},};

partition_t partitions[5] = {{
    .id = 0,
    .partitionname = "idle",
    .criticality = LEVEL_E,
    .systempartion = false,
    .entrypoint = &idle_main,
    .nb_ports = 0,
    .ports = 0,
},{
    .id = 1,
    .partitionname = "yellow_toggler",
    .criticality = LEVEL_A,
    .systempartion = false,
    .entrypoint = &yellow_toggler_main,
    .nb_ports = 1,
    .ports = p_yellow_toggler,
},{
    .id = 2,
    .partitionname = "red_toggler",
    .criticality = LEVEL_A,
    .systempartion = false,
    .entrypoint = &red_toggler_main,
    .nb_ports = 1,
    .ports = p_red_toggler,
},{
    .id = 3,
    .partitionname = "stio_sys",
    .criticality = LEVEL_A,
    .systempartion = true,
    .entrypoint = &stdio_sys_main,
    .nb_ports = 1,
    .ports = p_stio_sys,
},{
    .id = 4,
    .partitionname = "evil",
    .criticality = LEVEL_A,
    .systempartion = false,
    .entrypoint = &evil_main,
    .nb_ports = 1,
    .ports = p_evil,
},};

mem_req_t memoryp_dummy_1[2] = {{
    .type = CODE,
    .size = 8000,
    .access = READ_ONLY,
    .address = 0x8010000,
},{
    .type = DATA,
    .size = 8000,
    .access = READ_WRITE,
    .address = 0x20010000,
},};

mem_req_t memoryp_dummy_2[2] = {{
    .type = CODE,
    .size = 8000,
    .access = READ_ONLY,
    .address = 0x8012000,
},{
    .type = DATA,
    .size = 8000,
    .access = READ_WRITE,
    .address = 0x20012000,
},};

mem_req_t memoryp_stio_sys[2] = {{
    .type = CODE,
    .size = 8000,
    .access = READ_ONLY,
    .address = 0x8014000,
},{
    .type = DATA,
    .size = 8000,
    .access = READ_WRITE,
    .address = 0x20014000,
},};

mem_req_t memoryp_evil[2] = {{
    .type = CODE,
    .size = 8000,
    .access = READ_ONLY,
    .address = 0x8016000,
},{
    .type = DATA,
    .size = 8000,
    .access = READ_WRITE,
    .address = 0x20016000,
},};

part_mem_t partition_memory[4] = {{
    .id = 1,
    .partitionname = "dummy_1",
    .arr_size = 2,
    .memory_arr = memoryp_dummy_1,
    .mem_offset = 1024,
},{
    .id = 2,
    .partitionname = "dummy_2",
    .arr_size = 2,
    .memory_arr = memoryp_dummy_2,
    .mem_offset = 1024,
},{
    .id = 3,
    .partitionname = "stio_sys",
    .arr_size = 2,
    .memory_arr = memoryp_stio_sys,
    .mem_offset = 1024,
},{
    .id = 4,
    .partitionname = "evil",
    .arr_size = 2,
    .memory_arr = memoryp_evil,
    .mem_offset = 1024,
},};

const uint32_t majorFrameSeconds = 20000;

const window_schedule windowp_yellow_toggler[2] = {{
    .id = 1,
    .windowstartmilliseconds = 0,
    .windowdurationmilliseconds = 2000,
    .partitionperiodstart = true,
},{
    .id = 2,
    .windowstartmilliseconds = 10000,
    .windowdurationmilliseconds = 2000,
    .partitionperiodstart = true,
},};

const window_schedule windowp_red_toggler[2] = {{
    .id = 1,
    .windowstartmilliseconds = 3000,
    .windowdurationmilliseconds = 1000,
    .partitionperiodstart = true,
},{
    .id = 2,
    .windowstartmilliseconds = 13000,
    .windowdurationmilliseconds = 1000,
    .partitionperiodstart = true,
},};

const window_schedule windowp_stio_sys[2] = {{
    .id = 1,
    .windowstartmilliseconds = 4000,
    .windowdurationmilliseconds = 3000,
    .partitionperiodstart = true,
},{
    .id = 2,
    .windowstartmilliseconds = 14000,
    .windowdurationmilliseconds = 3000,
    .partitionperiodstart = true,
},};

const window_schedule windowp_evil[1] = {{
    .id = 1,
    .windowstartmilliseconds = 18000,
    .windowdurationmilliseconds = 2000,
    .partitionperiodstart = true,
},};

const partition_schedule partition_schedules[4] = {{
    .id = 1,
    .partitionname = "yellow_toggler",
    .peroidseconds = 100,
    .perioddurationseconds = 20,
    .numWindows = 2,
    .window_arr = windowp_yellow_toggler,
},{
    .id = 2,
    .partitionname = "red_toggler",
    .peroidseconds = 100,
    .perioddurationseconds = 10,
    .numWindows = 2,
    .window_arr = windowp_red_toggler,
},{
    .id = 3,
    .partitionname = "stio_sys",
    .peroidseconds = 100,
    .perioddurationseconds = 30,
    .numWindows = 2,
    .window_arr = windowp_stio_sys,
},{
    .id = 4,
    .partitionname = "evil",
    .peroidseconds = 200,
    .perioddurationseconds = 20,
    .numWindows = 1,
    .window_arr = windowp_evil,
},};

port_t *stio_channel_ports[3] = {
    &p_red_toggler[0],
    &p_yellow_toggler[0],
    &p_stio_sys[0],};

channel_t connection_table[1] = {{
    .id = 1,
    .channelname = "stio_channel",
    .nb_ports = 3,
    .ports = stio_channel_ports,
},};


