/* Lcd_Custom_Char

Up to 8 characters can be programmed in CGRAM, but because CGRAM is a RAM, characters are lost
on power off and must be reloaded on power on.
Assuming 2x16 LCD with HD44780 Hitachi controller compatible.

*/

#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p13, p14, p17, p18, p19, p20); // rs, e, d4, d5, d6, d7
AnalogIn ain(p15);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Defines 8 bar heights
char custom_char[8][8] = {
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}, // 0
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f}, // 1
    {0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x1f}, // 2
    {0x00,0x00,0x00,0x00,0x00,0x1f,0x1f,0x1f}, // 3
    {0x00,0x00,0x00,0x00,0x1f,0x1f,0x1f,0x1f}, // 4
    {0x00,0x00,0x00,0x1f,0x1f,0x1f,0x1f,0x1f}, // 5
    {0x00,0x00,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f}, // 6
    {0x00,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f}  // 7
};

BusOut Lcd_pins(p17, p18, p19, p20); // d4, d5, d6, d7

DigitalOut rs_pin(p13); // rs
DigitalOut e_pin(p14);  // e 

// Prepare write port
void writePort(int value) {

    Lcd_pins = value >> 4;  // Shifts 4 bit right.
    wait(0.000040f); // Delay
    e_pin = 0;
    wait(0.000040f);
    e_pin = 1;
    Lcd_pins = value;
    wait(0.000040f);
    e_pin = 0;
    wait(0.000040f);
    e_pin = 1;
}

int main() {
    float temp = ain;
    lcd.cls();
    //lcd.printf("Writing Characters...");
    wait(0.5);
    for (int j=0; j<8; j++) {

        rs_pin = 0; // Send command

        /* 0X40 is the initial CGRAM address. Because each character needs a total amount of 8 memory 
        locations, we increment addres in 8 units after each character.
        */
        writePort(0x40+8*j);
// Writes custom characters to the text LCD.
        rs_pin = 1; // Send the data here
        for (int i=0; i<8; i++) {
            writePort(custom_char[j][i]);
        }
    }
    lcd.cls();
    wait(0.010);
    lcd.locate(0,0);

// Prints loaded custom characters. ASCII codes 0 to 7.

    while(1){
        wait(0.2);
        temp = ain;
        if(temp>=0&&temp<=0.142){
        lcd.cls();
        lcd.putc(0);
        led1=0;
        led2=0;
        led3=0;
        led4=0;
        }
       if(temp>0.142&&temp<=0.284){
        lcd.cls();
        lcd.putc(1);
        led1=1;
        led2=0;
        led3=0;
        led4=0;
        }
       if(temp>0.284&&temp<=0.426){
        lcd.cls();
        lcd.putc(2);
        led1=1;
        led2=1;
        led3=0;
        led4=0;
        }
       if(temp>0.426&&temp<=0.568){ 
        lcd.cls();
        lcd.putc(3);
        led1=1;
        led2=1;
        led3=0;
        led4=0;
        }
       else if(temp>0.568&&temp<=0.710){   
        lcd.cls();
        lcd.putc(4);
        led1=1;
        led2=1;
        led3=1;
        led4=0;
        }
       else if(temp>0.710&&temp<=0.852){
        lcd.cls();
        lcd.putc(5);
        led1=1;
        led2=1;
        led3=1;
        led4=0;
        }
       else if(temp>0.852&&temp<=0.92){
        lcd.cls();
        lcd.putc(6);
        led1=1;
        led2=1;
        led3=1;
        led4=1;}
        
       else if(temp>0.92&&temp<=1.0){
        lcd.cls();
        lcd.putc(7);
        led1=1;
        led2=1;
        led3=1;
        led4=1;}
            

    }
 }
