
#include "mbed.h"
#include "EDUVANCE_WIFI_SHIELD.h"
//CONSTANTS FOR MODES
#define STATIONMODE 10 
#define APMODE 20
int AP_LOGIN =0;
int STATION_LOGIN= 0;
Serial pc(USBTX, USBRX);// COMPUTER DISPLAY
Serial esp(PTE0, PTE1); //ESP8266 SERIAL
extern int modeselector=0;
char ssid[32];    
char pwd[32]; 
bool aplogin=false;
const char ch = 's';
char *getreq,*ssid_new,*pass_new,*left,*right,*pad_string;
//ADD DEVICES,PINS AND LEDS HERE
DigitalOut  led1(LED_RED);      
int port=8266;




Timer t1;
Timer t2;
int setval=0;

int bufflen, DataRX, count, getcount, replycount, servreq, timeout;
int bufl, ipdLen, linkID, weberror, webcounter;


char webcount[8];

char timebuf[30];
char type[16];
char type1[16];
char channel[2];
char cmdbuff[32];
char replybuff[512];
char webdata[1024]; // This may need to be bigger depending on WEB browser used
char webbuff[4096];     // Currently using 1986 characters, Increase this if more web page data added
int mode_sel=0;

  // set server port
int SERVtimeout =5;    // set server timeout in seconds incase link breaks.void callback(void);

//TAKES SSID, PASSWORD AND PORT ADDRESS
void get_ssid_pass(char ssid_f[32],char pass_f[32],int port_f){
    pc.printf("\n\r+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\r\n");
    pc.printf("\n\r+++++++++++++++++++++ INITIALIZING ++++++++++++++++++++++++\r\n");
    pc.printf("\n\r+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\r\n");
    pc.printf("\r\n SSID is %s, PASSWORD is %s, PORT number is %d \r\n",ssid_f,pass_f,port_f);
    strcpy(ssid,ssid_f);
      strcpy(pwd,pass_f);
  //  port=8266;
    }
    
//SETS BAUD RATE
void setbaudrate(int baud_f){
    pc.baud(baud_f);
    esp.baud(baud_f);    
    }

// Serial Interrupt read ESP data
void callback() {    
    while (esp.readable()) {webbuff[count] = esp.getc();count++;}
    if(strlen(webbuff)>bufflen){DataRX=1;}  
    }
//SENDS COMMANDS TO ESP
void SendCMD(void){
       esp.printf("%s", cmdbuff);  
    }
//GETS REPLY IN THE FORM OF STRING    
void getreply(void){
    memset(replybuff, '\0', sizeof(replybuff));
    t1.reset(); t1.start();replycount=0;
    while(t1.read_ms()< timeout && replycount < getcount) {
        if(esp.readable()) {
            replybuff[replycount] = esp.getc();replycount++;
            }
        }
    t1.stop();  
    }
    
//READ THE RESPONSE AND TRIGGERS THE ACTIONS [CONTROLS LEDS]
void ReadWebData()
 {
    wait_ms(200);        
    esp.attach(NULL);
    count=0;DataRX=0;weberror=0;
    memset(webdata, '\0', sizeof(webdata)); 
       
    int x = strcspn (webbuff,"+");
    if(x){
        strcpy(webdata, webbuff + x);weberror=0;                                   
        int numMatched = sscanf(webdata,"+IPD,%d,%d:%s", &linkID, &ipdLen, type);
        
       
        if( strstr(webdata, "led1=1") != NULL ) {led1=0;}
        if( strstr(webdata, "led1=0") != NULL ) {led1=1;}
    
        sprintf(channel, "%d",linkID);        
        if (strstr(webdata, "GET") != NULL) {servreq=1;}
        if (strstr(webdata, "POST") != NULL) {servreq=1;}
        webcounter++;
        sprintf(webcount, "%d",webcounter);
        }
            else {
                memset(webbuff, '\0', sizeof(webbuff));
                esp.attach(&callback);weberror=1;
                }         
}




//READ THE RESPONSE AND TRIGGERS THE ACTIONS [CONTROLS LEDS]
void ReadWebData_register()
 {
    wait_ms(200);        
    esp.attach(NULL);
    count=0;DataRX=0;weberror=0;
    memset(webdata, '\0', sizeof(webdata)); 
       
    int x = strcspn (webbuff,"+");
    if(x){
        strcpy(webdata, webbuff + x);weberror=0;                                   
        int numMatched = sscanf(webdata,"+IPD,%d,%d:%s", &linkID, &ipdLen, type);
        

       //setval=1;
       //      if( strstr(webdata, "led1=1") != NULL ) {led1=0;}
    //    if( strstr(webdata, "led1=0") != NULL ) {led1=1;}
        sprintf(channel, "%d",linkID);        
        if (strstr(webdata, "GET") != NULL) {servreq=1;}
        if (strstr(webdata, "POST") != NULL) {servreq=1;}
        webcounter++;

        sprintf(webcount, "%d",webcounter);
          if (strstr(webdata, "ssid") != NULL) {
             newcre(webdata); }
        }
            else {
                memset(webbuff, '\0', sizeof(webbuff));
                esp.attach(&callback);weberror=1;
                }         
}





// Static WEB page TO DISPLAY   
void sendpage()
{    
// WEB page data     
    strcpy(webbuff, "<!DOCTYPE html>");
    strcat(webbuff, "<html><head><title>ESP8266 Mbed</title></head>");
    strcat(webbuff, "<body>");    
    
    strcat(webbuff, "<p><form method=\"GET\"></p>");
  
     
    if(led1==1){strcat(webbuff, "<p><input type=\"radio\" name=\"led1\" value=\"0\" checked>  Red LED off");
                strcat(webbuff, "<br><input type=\"radio\" name=\"led1\" value=\"1\" >  Red LED on");} 
        else{strcat(webbuff, "<p><input type=\"radio\" name=\"led1\" value=\"0\" >  Red LED off");
                strcat(webbuff, "<br><input type=\"radio\" name=\"led1\" value=\"1\" checked>  Red LED on");}   
                   
    strcat(webbuff, "<p><input type=\"submit\" value=\"send-refresh\" ></form></p>");    
 
    
    strcat(webbuff, "</body></html>");    
// end of WEB page data       
    bufl = strlen(webbuff); // get total page buffer length            
    sprintf(cmdbuff,"AT+CIPSEND=%d,%d\r\n", linkID, bufl); // send IPD link channel and buffer character length.
    timeout=200;getcount=7;
    SendCMD();
    getreply();                                                               
    SendWEB();  // send web page
    memset(webbuff, '\0', sizeof(webbuff));
    sendcheck();              
}

void sendpage_register()
{    
// WEB page data     
    strcpy(webbuff, "<!DOCTYPE html>");
    strcat(webbuff, "<html><head><title>ESP8266 Mbed</title></head>");
    strcat(webbuff, "<body>");    
    
   strcat(webbuff, "<form method=\"GET\">");
  
  //  strcat(webbuff, "<p><input type=\"radio\" name=\"led1\" value=\"0\" >  Red LED off");
    //            strcat(webbuff, "<br><input type=\"radio\" name=\"led1\" value=\"1\" checked>  Red LED on");
    strcat(webbuff, "<input type=\"text\" name=\"ssid\">  ssid");
    strcat(webbuff, "<br><input type=\"text\" name=\"pass\"  >  password");
   
          

    strcat(webbuff, "<input type=\"submit\" value=\"send-refresh\" >");
    strcat(webbuff,"</form>")    ;
 
    
    strcat(webbuff, "</body></html>");    
// end of WEB page data       
    bufl = strlen(webbuff); // get total page buffer length            
    sprintf(cmdbuff,"AT+CIPSEND=%d,%d\r\n", linkID, bufl); // send IPD link channel and buffer character length.
    timeout=200;getcount=7;
    SendCMD();
    getreply();                                                               
    SendWEB();  // send web page
    memset(webbuff, '\0', sizeof(webbuff));
  sendcheck();


              
}

//  wait for ESP "SEND OK" reply, then close IP to load web page
void sendcheck()
{
     weberror=1;timeout=500;getcount=24;
    t2.reset();t2.start();
    while(weberror==1 && t2.read() <5){        
        getreply();
        if (strstr(replybuff, "SEND OK") != NULL) {weberror=0;}  // wait for valid SEND OK 
        }
    if(weberror==1){ // restart connection
        strcpy(cmdbuff, "AT+CIPMUX=1\r\n"); 
        timeout=500;getcount=10;
        SendCMD();getreply(); 
        sprintf(cmdbuff,"AT+CIPSERVER=1,%d\r\n", port);
        timeout=500;getcount=10;
        SendCMD();getreply();
        }
        else{
            sprintf(cmdbuff, "AT+CIPCLOSE=%s\r\n",channel); // close current connection
            SendCMD();}       
    t2.reset();      
}    

// Large WEB buffer data send
void SendWEB()
{    
    int i=0;
    if(esp.writeable()) {
        while(webbuff[i]!='\0') {esp.putc(webbuff[i]);i++;}
        }     
} 

void ATcheck(void){
//FIRST AT COMMAND
    pc.printf("\r\n++++++++++++++++++++ AT RESPONSE ESP ++++++++++++++++++++\r\n");
    strcpy(cmdbuff,"AT\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
    }
  
void ATReset(void){
    //RESET ESP  
    pc.printf("+++++++++++++++++++++++++ Resetting ESP ++++++++++++++++++++++\r\n");  
    strcpy(cmdbuff,"AT+RST\r\n");
    timeout=2000;getcount=600;
    SendCMD();
    getreply();
    pc.printf(replybuff);
    pc.printf("%d",count);
    }

 void ListAccessPts(void){
//list access points
    pc.printf("++++++++++++++++++ Listing Access POINTS NEARBY +++++++++++++++\r\n");
    strcpy(cmdbuff,"AT+CWLAP\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    //strcpy(replybuff,"\0");
    pc.printf("%s\r\n",replybuff);
    //const char *tempdata=replybuff;
    //return replybuff;
     if (strstr(cmdbuff, ssid) != NULL){mode_sel=STATIONMODE;} 
     else{mode_sel=APMODE;}
    }
    
void StationModeSet(void){
    //SET CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("+++++++++++++++++++ SETTING ESP IN STATION MODE +++++++++++++++++\r\n");
    strcpy(cmdbuff,"AT+CWMODE=1\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
    }
    
void ApModeSet(void){
    //SET CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
      pc.printf("+++++++++++++++++++++ SETTING ESP IN AP MODE +++++++++++++++++++\r\n");
    strcpy(cmdbuff,"AT+CWMODE=2\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
    }
    
void ConnectWifiServer(void){
 
    pc.printf("\n+++++++++++++++ Connecting to WIFI SERVER (AP) +++++++++++++++\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(cmdbuff, "AT+CWJAP=\"");
    strcat(cmdbuff, ssid);
    strcat(cmdbuff, "\",\"");
    strcat(cmdbuff, pwd);
    strcat(cmdbuff, "\"\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",cmdbuff);
    }
    
void Commtype(void){
     // set CIPMUX to 0=Single,1=Multi
    pc.printf("+++++++++++++++++ Setting Connection of ESP in MULTI ++++++++++++++\r\n");
    strcpy(cmdbuff,"AT+CIPMUX=1\r\n");
    timeout=500;
    getcount=10;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
    }
    
void StartServer_AT(void){
    //START SERVER
    pc.printf("\n++++++++++++++++++++++ STARTING SERVER OF ESP +++++++++++++++++++\r\n");
    sprintf(cmdbuff,"AT+CIPSERVER=1,%d\r\n", port);
    timeout=500;getcount=10;
    SendCMD();
    getreply();
    sprintf(cmdbuff,"AT+CIPSTO=%d\r\n",SERVtimeout);
    timeout=500;getcount=50;
    SendCMD();
    getreply();
    }
void getIP(void){
    //GET IP
    pc.printf("\n Getting Server IP \r\n"); 
    strcpy(cmdbuff, "AT+CIFSR\r\n");
    timeout=1000;getcount=50;
    while(weberror==0){
        SendCMD();getreply();
        if (strstr(replybuff, "0.0.0.0") == NULL) {weberror=1;}  // wait for valid IP
        }
    pc.printf("\n Enter WEB address in your browser \r\n\n");
    replybuff[strlen(replybuff) - 8] = '\0';                
    char* IP = replybuff + 5;
    sprintf(webdata,"   http://%s:%d", IP, port);
    pc.printf(webdata);        
    }
void disp_ssid(void){
    
    pc.printf("\n\r++++++++++ DISPLAY CURRENT SSID ++++++++++\r\n");
    strcpy(cmdbuff,"AT+CWJAP?\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
    
    
    }
void finishup(void){
    //END PART
    bufflen=200;count=0;
    pc.printf("\n\n++++++++++++++++++++++++ READY ++++++++++++++++++++++++++\r\n\n");
    esp.attach(&callback);
    }



int startserver(void){
        pc.printf("++++++++++++++++++++++++ START MAIN SERVER ++++++++++++++++++++++\r\n");
     ATcheck();
     ATReset();
     StationModeSet();
      
    //list access points
    pc.printf("++++++++++++++++++++++++ Listing Access ESP ++++++++++++++++++++++\r\n");
    strcpy(cmdbuff,"AT+CWLAP\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
   /* 
    if (strstr(replybuff, ssid) != NULL) {
     
       t2.reset();t2.start();
        return 10;
   }
   else{
        t2.reset();t2.start();
        return 20;   
   }
    */
    return 0;
    }
    

void closeserver_AT(void){
       pc.printf("+++++++++++++++++ CLOSE THE SERVER ++++++++++++++\r\n");
          
     sprintf(cmdbuff,"AT+CIPCLOSE=%d\r\n", linkID);
      timeout=500;
    getcount=10;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
    
    
    
    strcpy(cmdbuff,"AT+CIPSERVER=0\r\n");
    timeout=500;
    getcount=10;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
    
    ATReset();
    
 
    }

void StationConfig_NO_SSID_NEED(void){
    
      pc.printf("\n\r------------------- IN THE STATION MODE(MATCHING SSID) -------------------\r\n");
    Commtype();
    StartServer_AT();
    getIP();
    finishup();
   
   }
   
void StationConfig_SSID_NEED(void){
       pc.printf("\n\r------------------- IN THE STATION MODE(NON MATCHED SSID) -------------------\r\n");
     StationModeSet();
    ConnectWifiServer();
    Commtype();
    StartServer_AT();
    getIP();
    finishup();
   
    }
    
void ApConfig(void){
     pc.printf("\n\r--------------------- IN THE AP MODE -----------------------\r\n");
     ApModeSet();
    Commtype();
    StartServer_AT();
    getIP();
    finishup();
    modeselector=20;
    }
void request_fetch_station(void){
  
     if(DataRX==1){
            ReadWebData();
           
            if (servreq == 1 && weberror == 0){sendpage();}
            esp.attach(&callback);     
           pc.printf(" IPD Data:\r\n\n Link ID = %d,\r\n IPD Header Length = %d \r\n IPD Type = %s\r\n", linkID, ipdLen, type);        
           pc.printf("\n\n  HTTP Packet: \n\n%s\n", webdata); 
           pc.printf("  Web Characters sent : %d\n\n", bufl);
          pc.printf("  -------------------------------------\n\n");
            //strcpy(lasthit, timebuf);
            servreq=0;               
        }    
    } 
    

void request_fetch_ap(void){
     if(DataRX==1){
          
            
            ReadWebData_register();
           
            if (servreq == 1 && weberror == 0){sendpage_register();}
            esp.attach(&callback);     
            pc.printf(" IPD Data:\r\n\n Link ID = %d,\r\n IPD Header Length = %d \r\n IPD Type = %s\r\n", linkID, ipdLen, type);        
            pc.printf("\n\n  HTTP Packet: \n\n%s\n", webdata); 
            pc.printf("  Web Characters sent : %d\n\n", bufl);
            pc.printf("  -------------------------------------\n\n");
         
            //strcpy(lasthit, timebuf);
         
            servreq=0;
                
        }   
       
      
    } 
        
char* getname(char *strd,const char s[2],int part){
   char *temp;  
   char *token,*dataarr[2];
   int i=0;
   
   token = strtok(strd, s);
   
   while( token != NULL ) 
   {
     dataarr[i]=token;
     i++;
     token = strtok(NULL, s);
   }
  
   if(part==1){temp=dataarr[0];}
   else if(part==2){temp=dataarr[1];}
   return temp;
    
}
void newcre(char webstring[]){
  //  char webstring[]="http://192.168.4.1:8266/ssid=hellogfg&pwd=thisispwd";
   char *pass_l,*ssid_temp,*pass_temp;
   getreq = strchr(webstring, ch);
   pc.printf("\n\r Desired substring:  %s\n\r", getreq);
   
   left = getname(getreq,"&",1);
   right = getname(getreq,"&",2);
   ssid_temp=getname(left,"=",2);
   pass_l=getname(right,"=",2);
   pass_temp=getname(pass_l," ",1);
   pc.printf( "\n\r new ssid is %s\n", ssid_temp );
   pc.printf( "\n\r new password is %s\n", pass_temp );
   if(strlen(ssid_temp)>4 && strlen(pass_temp)>4){
   get_ssid_pass(ssid_temp,pass_temp,8266);
//   wait(5);
    closeserver_AT();
    modeselector=10;
    StationConfig_SSID_NEED();
      request_fetch_station();
    }
    }



char* rtrim(char* string, char junk)
{
    char* original = string + strlen(string);
    while(*--original == junk);
    *(original + 1) = '\0';
    return string;
}
char* ltrim(char *string, char junk)
{
    char* original = string;
    char *p = original;
    int trimmed = 0;
    do
    {
        if (*original != junk || trimmed)
        {
            trimmed = 1;
            *p++ = *original;
        }
    }
    while (*original++ != '\0');
    return string;
}
 void data_sep_ssid(char replyback[],char ch){
     
   
     char *reply;
     reply = strchr(replyback, ch);
     pad_string = getname(reply,",",1);
     printf( "\n\r ssid is %s\n\r", pad_string );

     
     }   
void verifyssid(void){
    char *newd,*readb;
    
    //GET INITIAL ACCESS
    ATReset();
    StationModeSet();
    pc.printf("++++++++++++++++++++++++  INITIAL Listing Access ESP ++++++++++++++++++++++\r\n");
    strcpy(cmdbuff,"AT+CWLAP\r\n");
    timeout=8000;
    getcount=1000;
    SendCMD();
    getreply();
    pc.printf("%s\r\n",replybuff);
    newd=replybuff;
    //RECEIVE STORED SSID
    disp_ssid();
    int mo;
    if (strstr(replybuff, "No AP") != NULL){
       //DEVICE NEWLY INSTALLED
           pc.printf("++++++++++++++++++++++++ DEVICE NEWLY INSTALLED -> REGISTERATION ++++++++++++++++++++++\r\n");
             mo=startserver();
             t2.reset();t2.start();
           ApConfig();
       }
    else{
            data_sep_ssid(replybuff,'"');
            printf("The final ssid is %s\n\r", ltrim(rtrim( pad_string, '"'), '"')); 
            readb=ltrim(rtrim( pad_string, '"'), '"');
    

            if (strstr(newd, readb) != NULL) {
                 pc.printf("++++++++++++++++++++++++ SSID PRESENT ++++++++++++++++++++++\r\n");
                 get_ssid_pass(readb,"",8266);
                // AP_LOGIN=30;
                    mo=startserver();
                  t2.reset();t2.start();
                StationConfig_NO_SSID_NEED();
                
                 modeselector=10;
                 }
          
    }    
    }