
#include "mbed.h"
#include "EZOPH/EZOPH.h"

/* ------------------------------------------------ SERIAL OUTPUT DEBUGGING SETUP ------------------------------------------------ */

Serial device(USBTX, USBRX);  // tx, rx
int number = 0;

// Ph sensor
EZOPH sensor(p30, p7); // sda, scl

string value0 = NULL;
string value1 = NULL;
string value2 = NULL;
string value3 = NULL;

int value10 = 100;
int value11 = 100;
int value12 = 100;

float temp = 12.325;
float ph = 0.0;

int main(void)
{

    value0  = sensor.getSensorInfo();
    wait(2);
    value1 = sensor.getSensorStatus();
    wait(2);
    value10 = sensor.sensorLED(1);
    wait(2);
    value11 = sensor.QsensorLED();
    wait(2);
    value2 = sensor.calibrationQuery();
    wait(2);
    value3 = sensor.slope();
    wait(2);
    value12 = sensor.Tcompensation(20.0);
    wait(2);
    temp = sensor.QTcompensation();
    wait(2);
    ph = sensor.read();
    wait(2);
    sensor.sleep();
    /* ------------ SERIAL DEBUGGING OUTPUT ------------ */

    device.baud(9600);
    device.printf("\n\nNew set of mesure\r\n");
    device.printf("\nSensor info : %s\r\n", value0);
    device.printf("\nSensor status : %s\r\n", value1);
    device.printf("\nEnable sensor led: %d\r\n", value10);
    device.printf("\nQ sensor LED : %d\r\n", value11);
    device.printf("\nQuery calibration : %s\r\n", value2);
    device.printf("\nSlope : %s\r\n", value3);
    device.printf("\nSet temp compensation : %d\r\n", value12);
    device.printf("\nQT compensation : %.3f\r\n", temp);
    device.printf("\nPH reading : %.3f\r\n", ph);
}
