#ifndef mmSPI_H                                 // include guard.
#define mmSPI_H                                 // include guard.
/*----------------------------------------------//------------------------------
    student   : m-moore
    email     : gated.clock@gmail.com
    class     : embedded RTOS
    directory : USB_device_project/mmSPI
    file      : mmSPI.h
    date      : september 19, 2013.
----copyright-----------------------------------//------------------------------   
    licensed for personal and academic use.
    commercial use of original code must be approved by the account-holder of
    gated.clock@gmail.com
----description---------------------------------//------------------------------  
    this library provides the low-level SPI data and clock signaling 
    for communication with the altera development board, via four i/o
    pins available on the mbed development board's zigbee header.  
----notes---------------------------------------//------------------------------ 
------------------------------------------------//----------------------------*/
    #include "mbed.h"                           // standard mbed.org class.
//---defines------------------------------------//------------------------------
    #define mmSPI_MOSI p29                      // SPI interface pin.
    #define mmSPI_MISO p30                      // SPI interface pin.
    #define mmSPI_SCLK p9                       // SPI interface pin.
    #define mmCPU_CLK  p10                      // soft CPU system clock.
//==============================================//==============================
    class mmSPI
    {
      public:
                      mmSPI();                  // constructor.
                     ~mmSPI();                  // destructor.
        void          allocations();            // object allocations.       
        
        void          setSPIfrequency (float);  // initializations.
        void          setSendBuffer   (char * pcSendBuffer);
        void          setReceiveBuffer(char * pcReceiveBuffer);
        void          setNumberOfBytes(int    dNumberOfBytes);

                                                // SPI transceive loop.
        void          transceive_vector(char cPreCPU, char cPreSPI, char cScan, char cPostCPU);       
        
                                                // write/read CPU registers.     
        void          write_register    (char   cRegister, char cValue);
        void          write_IR          (char   cValueH,   char cValueL);
        char          read_register     (char   cRegister);
        void          read_all_registers(char * pcRegisters);
        
                                                // write/read CPU main-memory.
        void          write_memory(char cHData, char cLdata, char cAddress);
        unsigned int  read_memory (char cAddress);
        
        void          step();                   // step the CPU.
        
        void          clear_transmit_vector();  // fill with 0.
        
        unsigned long SPIClockCount();          // return SPI clock count.
        unsigned long CPUClockCount();          // return CPU clock count.      
        
      private:
      
      DigitalOut  * pMOSI;                      // SPI pin.
      DigitalOut  * pMISO;                      // SPI pin.
      DigitalOut  * pSCLK;                      // SPI pin.
      DigitalOut  * pCPUclk;                    // soft cpu clock.
      char        * pcSend;                     // SPI transmit vector.
      char        * pcReceive;                  // SPI receive  vector.
      float         fSPIfreq;                   // SPI clock   frequency.
      float         fSPIquarterP;               // SPI quarter period.
      int           dNumBytes;                  // number of SPI bytes.
      int           dLoop01;                    // loop index.
      int           dLoop02;                    // loop index.
      unsigned long ulSPIclkCount;              // SPI clock count.
      unsigned long ulCPUclkCount;              // CPU clock count.
    };
//----------------------------------------------//------------------------------
#endif                                          // include guard.