#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"

//Input system
AnalogIn emg1(A0); //right biceps
AnalogIn emg2(A1); //right triceps
AnalogIn emg3(A2); //left biceps
AnalogIn emg4(A3); //left triceps

//EMG tickers, these tickers are called in the mainscript with fsample 500Hz, also sends to HIDscope with same fsample
Ticker sample_ticker; 


//HIDscope to check whether filter is functional or not
HIDScope scope(4);  // number of channels

//BiQuad Chains for each EMG, total 4 chains
//EMG1!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//Highpass
BiQuadChain highp1;
BiQuad highp1_1( 9.21171e-01, -1.84234e+00, 9.21171e-01, -1.88661e+00, 8.90340e-01 );
BiQuad highp1_2( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.94922e+00, 9.53070e-01 );

//Notch
BiQuadChain notch1;
//BiQuad notch1( 0.9826967461632813, -1.9498957776049861, 0.9826967461632813, -1.9498957776049861,0.9653934923265625 );
//BiQuad notch2( 1.00000e+00, -1.99921e+00, 9.99215e-01, -1.99930e+00, 9.99301e-01 );
BiQuad notch1_1( 9.56543e-01, -1.82035e+00, 9.56543e-01, -1.84459e+00, 9.53626e-01 );
BiQuad notch1_2( 1.00000e+00, -1.90305e+00, 1.00000e+00, -1.87702e+00, 9.59471e-01 );

//Lowpass 4th order cutoff 3Hz
BiQuadChain lowp1;
BiQuad lowp1_1( 7.69910e-09, 1.53982e-08, 7.69910e-09, -1.96542e+00, 9.65769e-01 );
BiQuad lowp1_2( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.98532e+00, 9.85677e-01 );

//EMG2!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//Highpass
BiQuadChain highp2;
BiQuad highp2_1( 9.21171e-01, -1.84234e+00, 9.21171e-01, -1.88661e+00, 8.90340e-01 );
BiQuad highp2_2( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.94922e+00, 9.53070e-01 );

//Notch
BiQuadChain notch2;
//BiQuad notch1( 0.9826967461632813, -1.9498957776049861, 0.9826967461632813, -1.9498957776049861,0.9653934923265625 );
//BiQuad notch2( 1.00000e+00, -1.99921e+00, 9.99215e-01, -1.99930e+00, 9.99301e-01 );
BiQuad notch2_1( 9.56543e-01, -1.82035e+00, 9.56543e-01, -1.84459e+00, 9.53626e-01 );
BiQuad notch2_2( 1.00000e+00, -1.90305e+00, 1.00000e+00, -1.87702e+00, 9.59471e-01 );

//Lowpass 4th order cutoff 3Hz
BiQuadChain lowp2;
BiQuad lowp2_1( 7.69910e-09, 1.53982e-08, 7.69910e-09, -1.96542e+00, 9.65769e-01 );
BiQuad lowp2_2( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.98532e+00, 9.85677e-01 );

//EMG3!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//Highpass
BiQuadChain highp3;
BiQuad highp3_1( 9.21171e-01, -1.84234e+00, 9.21171e-01, -1.88661e+00, 8.90340e-01 );
BiQuad highp3_2( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.94922e+00, 9.53070e-01 );

//Notch
BiQuadChain notch3;
//BiQuad notch1( 0.9826967461632813, -1.9498957776049861, 0.9826967461632813, -1.9498957776049861,0.9653934923265625 );
//BiQuad notch2( 1.00000e+00, -1.99921e+00, 9.99215e-01, -1.99930e+00, 9.99301e-01 );
BiQuad notch3_1( 9.56543e-01, -1.82035e+00, 9.56543e-01, -1.84459e+00, 9.53626e-01 );
BiQuad notch3_2( 1.00000e+00, -1.90305e+00, 1.00000e+00, -1.87702e+00, 9.59471e-01 );

//Lowpass 4th order cutoff 3Hz
BiQuadChain lowp3;
BiQuad lowp3_1( 7.69910e-09, 1.53982e-08, 7.69910e-09, -1.96542e+00, 9.65769e-01 );
BiQuad lowp3_2( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.98532e+00, 9.85677e-01 );

//EMG4!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//Highpass
BiQuadChain highp4;
BiQuad highp4_1( 9.21171e-01, -1.84234e+00, 9.21171e-01, -1.88661e+00, 8.90340e-01 );
BiQuad highp4_2( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.94922e+00, 9.53070e-01 );

//Notch
BiQuadChain notch4;
//BiQuad notch1( 0.9826967461632813, -1.9498957776049861, 0.9826967461632813, -1.9498957776049861,0.9653934923265625 );
//BiQuad notch2( 1.00000e+00, -1.99921e+00, 9.99215e-01, -1.99930e+00, 9.99301e-01 );
BiQuad notch4_1( 9.56543e-01, -1.82035e+00, 9.56543e-01, -1.84459e+00, 9.53626e-01 );
BiQuad notch4_2( 1.00000e+00, -1.90305e+00, 1.00000e+00, -1.87702e+00, 9.59471e-01 );

//Lowpass 4th order cutoff 3Hz
BiQuadChain lowp4;
BiQuad lowp4_1( 7.69910e-09, 1.53982e-08, 7.69910e-09, -1.96542e+00, 9.65769e-01 );
BiQuad lowp4_2( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.98532e+00, 9.85677e-01 );


//Filtered EMG signals from the end of the chains
double emg1_filtered, emg2_filtered, emg3_filtered, emg4_filtered;

void emgsample(){
    //All EMG signal through Highpass
    double emgread1 = emg1.read();
    double emgread2 = emg2.read();
    double emg1_highpassed = highp1.step(emgread1);
    double emg2_highpassed = highp2.step(emgread2);
    //double emg3_highpassed  = highp3.step(emg3.read());
    //double emg4_highpassed = highp4.step(emg4.read());
    
    //All EMG highpassed through Notch
    double emg1_notched = notch1.step(emg1_highpassed);
    double emg2_notched = notch2.step(emg2_highpassed);
    //double emg3_notched = notch3.step(emg3_highpassed);
    //double emg4_notched = notch4.step(emg4_highpassed);
    
    //All EMG notched rectify
    double emg1_abs = abs(emg1_notched);
    double emg2_abs = abs(emg2_notched);
    //double emg3_abs = abs(emg3_notched);
    //double emg4_abs = abs(emg4_notched);
    
    //All EMG abs into lowpass
    emg1_filtered = lowp1.step(emg1_abs);
    emg2_filtered = lowp2.step(emg2_abs);
    //emg3_filtered = lowp3.step(emg3_abs);
    //emg4_filtered = lowp4.step(emg4_abs);
    
    
    //Send data to HIDScope
    scope.set(0,emg1_filtered );
    scope.set(1,emgread1);
    scope.set(2,emg2_filtered);
    scope.set(3,emgread2);
    scope.send();
    }
    
int main() {
    highp1.add( &highp1_1 ).add( &highp1_2 );
    notch1.add( &notch1_1 ).add( &notch1_2 );
    lowp1.add( &lowp1_1 ).add(&lowp1_2);
    
    highp2.add( &highp2_1 ).add( &highp2_2 );
    notch2.add( &notch2_1 ).add( &notch2_2 );
    lowp2.add( &lowp2_1 ).add(&lowp2_2);    
    
    highp3.add( &highp3_1 ).add( &highp3_2 );
    notch3.add( &notch3_1 ).add( &notch3_2 );
    lowp3.add( &lowp3_1 ).add(&lowp3_2);
     
    highp4.add( &highp4_1 ).add( &highp4_2 );
    notch4.add( &notch4_1 ).add( &notch4_2 );
    lowp4.add( &lowp4_1 ).add(&lowp4_2);
    
    
    sample_ticker.attach(&emgsample, 0.001);
    
    while(true){}
    
    }
    
    

    
    
    
    


