#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"

//Input system
AnalogIn emg1(A0); //right biceps
AnalogIn emg2(A1); //right triceps
AnalogIn emg3(A2); //left biceps
AnalogIn emg4(A3); //left triceps

//EMG tickers, these tickers are called in the mainscript with fsample 500Hz, also sends to HIDscope with same fsample
Ticker sample_ticker; 


//HIDscope to check whether filter is functional or not
HIDScope scope(2);  // aantal kanalen voor je HIDScope

//BiQuad Chains
//Highpass
BiQuadChain highp;
BiQuad highp1( 9.21171e-01, -1.84234e+00, 9.21171e-01, -1.88661e+00, 8.90340e-01 );
BiQuad highp2( 1.00000e+00, -2.00000e+00, 1.00000e+00, -1.94922e+00, 9.53070e-01 );

//Notch
BiQuadChain notch;
BiQuad notch1( 0.9826967461632813, -1.9498957776049861, 0.9826967461632813, -1.9498957776049861,0.9653934923265625 );
//BiQuad notch2( 1.00000e+00, -1.99921e+00, 9.99215e-01, -1.99930e+00, 9.99301e-01 );

//Lowpass
BiQuadChain lowp;
BiQuad lowp1( 8.76555e-05, 1.75311e-04, 8.76555e-05, -1.97334e+00, 9.73695e-01 );
//BiQuad lowp2( 1.00000e+00, 2.00000e+00, 1.00000e+00, -1.94922e+00, 9.53070e-01 );



//Filtered EMG signals from the end of the chains
double emg1_filtered, emg2_filtered, emg3_filtered, emg4_filtered;

void emgsample(){
    //All EMG signal through Highpass
    double emgread1 = emg1.read();
    double emg1_highpassed = highp.step( emgread1);
    //double emg2_highpassed  = highp.step(emg2.read());
    //double emg3_highpassed  = highp.step(emg3.read());
    //double emg4_highpassed = highp.step(emg4.read());
    
    //All EMG highpassed through Notch
    double emg1_notched = notch.step(emg1_highpassed);
    //double emg2_notched = notch.step(emg2_highpassed);
    //double emg3_notched = notch.step(emg3_highpassed);
    //double emg4_notched = notch.step(emg4_highpassed);
    
    //All EMG notched rectify
    double emg1_abs = abs(emg1_notched);
    //double emg2_abs = abs(emg2_notched);
    //double emg3_abs = abs(emg3_notched);
    //double emg4_abs = abs(emg4_notched);
    
    //All EMG abs into lowpass
    emg1_filtered = lowp.step(emg1_abs);
    //emg2_filtered = lowp.step(emg2_abs);
    //emg3_filtered = lowp.step(emg3_abs);
    //emg4_filtered = lowp.step(emg4_abs);
    
    
    //Send data to HIDScope
    scope.set(0,emg1_filtered );
    scope.set(1,emgread1);
    scope.send();
    }
    
int main() {
    highp.add( &highp1 ).add( &highp2 );
    notch.add( &notch1 );
    lowp.add( &lowp1 );
    
    sample_ticker.attach(&emgsample, 0.001);
    
    while(true){}
    
    }
    
    

    
    
    
    


