#ifndef _ROS_std_msgs_ByteMultiArray_h
#define _ROS_std_msgs_ByteMultiArray_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"
#include "std_msgs/MultiArrayLayout.h"
#include "std_msgs/byte.h"

namespace std_msgs
{

  class ByteMultiArray : public ros::Msg
  {
    public:
      std_msgs::MultiArrayLayout layout;
      uint8_t data_length;
      std_msgs::byte st_data;
      std_msgs::byte * data;

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      offset += this->layout.serialize(outbuffer + offset);
      *(outbuffer + offset++) = data_length;
      *(outbuffer + offset++) = 0;
      *(outbuffer + offset++) = 0;
      *(outbuffer + offset++) = 0;
      for( uint8_t i = 0; i < data_length; i++){
      offset += this->data[i].serialize(outbuffer + offset);
      }
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      offset += this->layout.deserialize(inbuffer + offset);
      uint8_t data_lengthT = *(inbuffer + offset++);
      if(data_lengthT > data_length)
        this->data = (std_msgs::byte*)realloc(this->data, data_lengthT * sizeof(std_msgs::byte));
      offset += 3;
      data_length = data_lengthT;
      for( uint8_t i = 0; i < data_length; i++){
      offset += this->st_data.deserialize(inbuffer + offset);
        memcpy( &(this->data[i]), &(this->st_data), sizeof(std_msgs::byte));
      }
     return offset;
    }

    virtual const char * getType(){ return "std_msgs/ByteMultiArray"; };
    virtual const char * getMD5(){ return "70ea476cbcfd65ac2f68f3cda1e891fe"; };

  };

}
#endif