
// Timer 3 is used by mbed library functions: Ticker, Timer, Wait

#include "TARGET_LPC1768/LPC17xx.h"
#include "mbed.h"
#include "Timer3.h"

funcptr3 timer3ISR;

void Timer3_IRQHandler(void)
{
#define ICR0    (1<<5)              // CR0 interrupt bit
int count; 
    if (LPC_TIM3->IR & ICR0)
    {
        count = LPC_TIM3->TC;
        LPC_TIM3->TCR = 2;         // Disable
        LPC_TIM3->IR = ICR0;       // clear the interrupt
        timer3ISR(count);          // return the count
    }
}

void Timer3_init(funcptr3 callback)
{
    timer3ISR = callback;
    LPC_SC->PCONP |= (1<<23);           // Power on the Timer3
    LPC_TIM3->TCR = 2;                  // Reset the timer and prescale counters on next PCLK
    LPC_SC->PCLKSEL1 &= ~(3<<14);
    LPC_SC->PCLKSEL1 |= (1<<14);        // Select  CCLK for Timer3
    LPC_PINCON->PINSEL1 |= (3<<16)|(3<<14);     // Connect CAP3.0 to P15, CAP3.1 to P16
    LPC_PINCON->PINMODE1 &=~((3<<16)|(3<<14));
    LPC_PINCON->PINMODE1 |= (2<<16)|(2<<14);    // no pull-p or pull-down
    LPC_TIM3->CTCR = 1;                 // TC incremented by CAP3.0 (P15) rising edge
    LPC_TIM3->PR = 0;                   // Set prescale register to zero
    LPC_TIM3->CCR = 0x30;              // Capture on CAP3.1 (P16) falling edge and interrupt
    NVIC_SetPriority(TIMER3_IRQn, 9);
    NVIC_SetVector(TIMER3_IRQn, (uint32_t)&Timer3_IRQHandler);
    NVIC_EnableIRQ(TIMER3_IRQn);
    LPC_TIM3->TCR = 2;                  // Disable
}

