
#include "mbed.h"
#include "Timer2.h"
#include "Timer3.h"
/*
    Connect P8 (MAT2.0) to P16 (CAP3.1)
    Connect external input on P15 (CAP3.0) to PWM output on P26
*/
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut out1(p5), out2(p6);
PwmOut pw(p26);

int done;
void Timer3Isr(int count)
{
    pc.printf("count=%d\n\r", count);
    LPC_TIM2->TCR = 2;  // Disable Timer2
    done = 1;
}

void Timer2Isr(void)
{
    out1 = !out1;
}

int main(void)
{
int prescale;   // Units are 0.1 second.

    out1 = 0;
    out2 = 0;
    pw.period_us(10);
    pw.write(0.5);
    Timer3_init(Timer3Isr);
    Timer2_init(Timer2Isr);
    while(1)
    {
        pc.printf("PS: ");
        pc.scanf("%d", &prescale);      // Interval is <prescale>+1 * 0.1 second.
        pc.printf("%d\n\r", prescale);
        done = 0;
        Timer2_start(prescale);
        while (!done)
            out2 = !out2;
    }
}


