#ifndef SCD41_H
#define SCD41_H

#include "mbed.h"
// i2c sensor address
#define SCD41_ADR  0x62
// sensor automatically starts measurement. RDY pin signals measurement ready.
#define COMMAND_CONTINUOUS_MEASUREMENT {0x21, 0xB1}
#define COMMAND_CONTINUOUS_MEASUREMENT_LEN 2
// command that needs to be sent before reading out the measurement result
#define COMMAND_READ_MEASUREMENT {0xec, 0x05}
#define COMMAND_READ_MEASUREMENT_LEN 2

    /** Create Scd41 controller class
     *
     * @param Scd41 class
     *
     */
class Scd41 {
 
public:
     enum ScdError {
         SCD_ERROR_NO_ERROR,
         SCD_ERROR_COM_ERROR
     };

    /** Create a Scd41 object using the specified I2C object
     * @param sda - mbed I2C interface pin
     * @param scl - mbed I2C interface pin
     * @param I2C Frequency (in Hz)
     *
     * @return none
     */
     Scd41(PinName sda, PinName scl, int i2cFrequency, PinName rdy);
    
    /** Initialize settings and start Auto-Measurement 
     *
     * @param --none--
     *
     * @return enum ScdError
     */
    uint8_t init();
    
    /** Check if measurement is ready
     *
     * @param --none--
     *
     * @return bool true=ready
     */
    bool isMeasurementReady();
    
    /** Read all environmental parameters (CO2, Temp and Hum) from sensor
     *
     * @param --none-
     *
     * @return enum ScdError
     */
    uint8_t readMeasurement();
    
    /** Get current temperature value
     *
     * @param --none--
     *
     * @return enum SCDerror
     */
    float getTemp(){ return _temp;};
    
    /** Get current Humidity value
     *
     * @param --none--
     *
     * @return enum SCDerror
     */
    float getHumi(){ return _humi;};
    
    /** Get current CO2 value
     *
     * @param --none--
     *
     * @return enum SCDerror
     */
    float getCo2(){ return _co2;};
 
private:
    I2C           _i2c;
    DigitalIn     _rdy;
    float         _temp;
    float         _humi;
    float         _co2;
 
};    
#endif