#include "mbed.h"

//------------------------------------
// Recopie de Serial pc vers Serial IRDA
//------------------------------------
IRDA_HandleTypeDef hirda1;
Serial pc(SERIAL_TX, SERIAL_RX);
Serial irda(PA_9, PA_10);
uint8_t c;
char echo = 0;
#define RX_BUFFER_SIZE  50
uint8_t rxbuffer[RX_BUFFER_SIZE] = {0};
char rxi = 0;
#define TX_BUFFER_SIZE  50
uint8_t txbuffer[TX_BUFFER_SIZE] = {0};
char txi = 0;

#define HELLO 0x68

void Irda1_init(void);
void IRDA_RxCpltCallback(void);
void PC_RxCpltCallback(void);

unsigned long* USART_CR3 = (unsigned long*)0x40013808;  // offset 0x08
unsigned long* USART_CR2 = (unsigned long*)0x40013804;  // offset 0x04
unsigned long* USART_CR1 = (unsigned long*)0x40013800;  // offset 0x00
unsigned long* USART_GTPR = (unsigned long*)0x40013810; // offset 0x10
unsigned long* USART_BRR = (unsigned long*)0x4001380C; // offset 0x0C

void Irda1_init(void)
{
    hirda1.Instance = USART1;
    hirda1.Init.BaudRate = 9600;
    hirda1.Init.WordLength = IRDA_WORDLENGTH_8B;
    hirda1.Init.Parity = IRDA_PARITY_NONE;
    hirda1.Init.Prescaler = 1;
    hirda1.Init.PowerMode = IRDA_POWERMODE_NORMAL;
    hirda1.Init.Mode = IRDA_MODE_TX_RX;
    HAL_IRDA_Init(&hirda1);
}

int main() {
    pc.baud(9600);
    pc.printf("IRDA BOOTLOADER.\r\n");
    
    Irda1_init();
    
    c = HELLO;
    irda.putc(c);
    
    while(1) {
        if(irda.readable()){
            c = irda.getc();
            while(!pc.writeable());
            pc.putc(c);
        }
    
        if(pc.readable()){
            c = pc.getc();
            while(!irda.writeable());
            irda.putc(c);
        }
    }
}
 