#include "FiltrePB.h"

FiltrePB::FiltrePB(){
}

FiltrePB::FiltrePB(float fc, float Ts) : Ts_m(Ts), fc_m(fc){
    vep_m=vsp_m=vs_m=0.0;
    tau_m=1.0/(fc_m*2*3.1415);    //calcul de la constante de temps
    a_m=1.0/(1+(2*tau_m/Ts_m));     //calcul du coefficient a du filtre
    b_m=(1.0-(2*tau_m/Ts_m))*a_m;       //calcul du coefficient b du filtre
}

float FiltrePB::compute(float ve){
    vs_m=a_m*ve+a_m*vep_m-b_m*vsp_m;       
    vep_m=ve;
    vsp_m=vs_m;      
    return vs_m;
}

