/***************************************************************************
AUTHORS     : BRUNO LARNAUDIE (Main functions) bruno.larnaudie@u-psud.fr            
              MATHIEU GARIVET (Object Oriented aspect)                               
                                                                                                                                                                   *
INSTITUTION : IUT de CACHAN - 9 av. de la div. Leclerc - 94230 CACHAN                
                                                                                      
VERSIONS    : v1 (03/07/2012) : FIFO organisation                             
              v2 (18/02/2016) : Controller aand Peripheral organisation

****************************************************************************
Copyright 2016 LARNAUDIE GARIVET

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
***************************************************************************/
#include "mbed.h"
#include "PeripheralCAN.h"

PeripheralCAN::PeripheralCAN(){
}

PeripheralCAN::PeripheralCAN(ControllerCAN* controller) : controllerCAN(controller) {
    controllerCAN->attach(this);
}

void PeripheralCAN::addIdRead(unsigned short* Id){
    IdsRead.push_back(Id);
}

bool PeripheralCAN::writeOnCAN(unsigned short Id, const char *data, char len, unsigned int timeout){
    uint32_t tickstart = 0;

    /* Get start tick value */
    tickstart = HAL_GetTick();
    
    do{
        if (len != 0){
            if(controllerCAN->writeData(Id, data, len)) return true;
        }
        else{
            if(controllerCAN->writeRemote(Id)) return true;
        }
    } while((HAL_GetTick() - tickstart) < timeout);
    
    return false;
}

void PeripheralCAN::init(void){
}
    
void PeripheralCAN::update(const unsigned short& Id, const CANMessage& msg){
}

vector<unsigned short*> PeripheralCAN::getIdsRead(void){
    return IdsRead;
}
