/***************************************************************************
AUTHORS     : BRUNO LARNAUDIE (Main functions) bruno.larnaudie@u-psud.fr            
              MATHIEU GARIVET (Object Oriented aspect)                               
                                                                                                                                                                   *
INSTITUTION : IUT de CACHAN - 9 av. de la div. Leclerc - 94230 CACHAN                
                                                                                      
VERSIONS    : v1 (03/07/2012) : FIFO organisation                             
              v2 (18/02/2016) : Controller and Peripheral organisation

****************************************************************************
Copyright 2016 LARNAUDIE GARIVET

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
***************************************************************************/
#include "mbed.h"
#include "ControllerCAN.h"

ControllerCAN::ControllerCAN(PinName rd, PinName td) : can(rd, td, 250000) {
    // Enable bus off auto mangement
    unsigned long* CAN_MCR = (unsigned long*) 0x40006400;
    *CAN_MCR |= CAN_MCR_ABOM;
    
    can.attach(callback(this, &ControllerCAN::can_ISR_Reader));        // CAN ISR
    
    FIFO_ecriture = 0;
    FIFO_lecture = 0;
    FIFO_occupation = 0;
    FIFO_max_occupation = 0;
}

ControllerCAN::~ControllerCAN(){
}

void ControllerCAN::attach(PeripheralCAN* peripheral){
    peripherals.push_back(peripheral);
}

long ControllerCAN::writeData(long Id, const char *data, char len){
    CANMessage msg(Id, data, len);
    return (can.write(msg));
}

long ControllerCAN::writeRemote(long Id){
    CANMessage msg(Id);
    return (can.write(msg));
}

char ControllerCAN::FIFOread(void){
    FIFO_occupation=FIFO_ecriture-FIFO_lecture;
    if(FIFO_occupation<0)
        FIFO_occupation=FIFO_occupation+SIZE_FIFO;  
    if(FIFO_max_occupation<FIFO_occupation)
        FIFO_max_occupation=FIFO_occupation;
    if(FIFO_occupation>SIZE_FIFO)
        {}
    if(FIFO_occupation!=0)
    {
        char res = 0;
        for (uint32_t i = 0; i < peripherals.size(); i++){
            vector<unsigned short*> IdsRead = peripherals[i]->getIdsRead();
            for (uint32_t j = 0; j < IdsRead.size() ; j++){
                if (can_MsgRx[FIFO_lecture].id == *(IdsRead[j])){
                    peripherals[i]->update(*(IdsRead[j]), can_MsgRx[FIFO_lecture]);
                    res = 1;
                    break;
                }
            }
            if(res) break;
        }
        FIFO_lecture=(FIFO_lecture+1)%SIZE_FIFO;
        return 1;
    }
    return -1;
}

void ControllerCAN::can_ISR_Reader(void){
    if (can.read(can_MsgRx[FIFO_ecriture]))
    {
      // FIFO gestion
       FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
    }
}
