#include "mbed.h"
#include "SDFileSystem.h"
 
//Create an SDFileSystem object
SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd"); //mosi, miso, sclk, cs
Serial pc       (USBTX, USBRX); 
Timer t;

int main()
{
    pc.baud(115200);
    pc.printf("starting..\n");
    
    //Mount the filesystem
    sd.mount();
 
    //Perform a write test
    pc.printf("\nWriting to SD card...\n");
    FILE *fp = fopen("/sd/cobawaktu.csv", "w");
    if (fp != NULL) {

        // t.start();
        // fprintf(fp, "We're, writing, to, an, SD, card!,yayyy!!.");
        // t.stop();
        // pc.printf("The time taken for writing was %f seconds\n\n", t.read());

        float i = 0.001;
        int j=1;
        t.start();
        while (t.read()<=0.001){
            fprintf(fp, "%.3f,",i);
            if ((j%10)==0) fprintf(fp, "\n");
            i+=0.001;
            j++;
        }
        t.stop();
        fprintf(fp, "!\n");
        pc.printf("The time taken was %f seconds\n\n", t.read());

        //i = 0;
//        t.start();
//        while (t.read()<=0.0001){
//            fprintf(fp, "%d,",100+i);
//            if ((i%10)==0) fprintf(fp, "\n");
//            i++;
//        }
//        t.stop();
//        fprintf(fp, ".\n");
//        pc.printf("The time taken was %f seconds\n\n", t.read());
        fclose(fp);
    }

    pc.printf("Reading from SD card...\n");
    fp = fopen("/sd/cobawaktu.csv", "r");
    if (fp != NULL) {
        char c = fgetc(fp);
        // if (c == 'W')
        //     pc.printf("success!\n\n");
        // else
        //     pc.printf("incorrect char (%c)!\n", c);
        
        // t.start();
        while(c!='!'){
            pc.printf("%c",c);
            c=fgetc(fp);
        }
        t.stop();
        pc.printf("\nThe time taken for reading was %f seconds\n\n", t.read());
        
        fclose(fp);
    } else {
        pc.printf("failed!\n");
    }
 
    //Unmount the filesystem
    sd.unmount();
}