/*
  DJI Naza (v1, v1 Lite, V2) example
  (c) Stephane Driussi 20141128
  Not for commercial use

  Refer to naza_decoder_wiring.jpg diagram for proper connection
  http://www.rcgroups.com/forums/showthread.php?t=1995704
  
*/

#include "mbed.h"
#include "NazaDecoderLib.h"

DigitalOut ledG(P0_17); // Green LED
RawSerial pc(USBTX, USBRX);
RawSerial naza(P0_4, P0_0);
Timer t;

char c;
int sat;
char tmp[90];

int main()
{
    t.start();
    ledG = 1;
    naza.baud(115200);
    while(1) {
        if(naza.readable()) {
            c = naza.getc();
            NazaDecoder.decode(c);
        }
        if (t.read_ms() > 1000) {
            pc.baud(9600);
            wait_ms(10);
            NazaDecoder.getDebug(pc, tmp);
            wait_ms(10);
            naza.baud(115200);
            sat = NazaDecoder.getNumSat();
            t.reset();
            if (sat > 4) ledG = 0;
            else ledG = 1;
        }
    }
}